#ifndef Aztec2_TimeSlider_Header
#define Aztec2_TimeSlider_Header

#include <MListsTrees.h>
#include <MKeyableValue.h>
#include <gui/MContainer.h>

#include <gui/MTextField.h>

namespace AztecGUI {

  class MTimeSlider : public Aztec::MContainer {
  public:
    static MTimeSlider* getInstance();

    MTimeSlider();
    
    bool setScrollRange(int Min, int Max);
    bool setScrollPos(int Pos);
    int getScrollPos();
    int getScrollMin();
    int getScrollMax();
    
    void clearAllKeyLists();
    void addKeyableValue(const Aztec::MKeyableValuePtr &value);
    
    // MComponent methods
    bool onPaint();
    bool onMousePressed(const Aztec::MMouseEvent &event);
    bool onMouseReleased(const Aztec::MMouseEvent &event);
    bool onMouseMove(const Aztec::MMouseEvent &event);

  protected:
     int               m_ScrollMin, m_ScrollMax, m_ScrollPos;
     bool              m_Tracking;

     typedef std::set<Aztec::MKeyableValuePtr> KeyValueSet;
     KeyValueSet m_KeyingList;

  };

}

#endif

