#ifndef Aztec3DSceneCanvas_Header
#define Aztec3DSceneCanvas_Header

#include <controls/AztecGLCanvas.h>
#include <MMath.h>


namespace AztecGUI {

  class Aztec3DSceneCanvas : public AztecGLCanvas
  {
  public:
    typedef enum { TextureNone, TextureNearest, TextureLinear }  TextureModeEnum;
    typedef enum { ShadingWireframe, ShadingFlat, ShadingSmooth } ShadingModeEnum;


    Aztec3DSceneCanvas(AztecView *parentView);
    ~Aztec3DSceneCanvas();

    const Aztec::MVector3& getCameraRotation() const;
    void setCameraRotation(const Aztec::MVector3 &rotation);

    void setPerspective(bool persp);
    bool isPerspective() const;

    float getZoomFactor() const;
    void setZoomFactor(float factor);

    float getDistance() const;
    void setDistance(float distance);

    void getGate(float &left, float &top, float &right, float &bottom) const;

    const Aztec::MVector3& getCameraFocus() const;
    void setCameraFocus(const Aztec::MVector3 &focus);

    void getScreenVectors(Aztec::MVector3 &u, Aztec::MVector3 &v);

    void setTextureMode(TextureModeEnum mode);
    TextureModeEnum getTextureMode();

    void setShadingMode(ShadingModeEnum mode);
    ShadingModeEnum getShadingMode();

    void setBackfaceCulling(bool cull);
    bool getBackfaceCulling();

    void setHeadlight(bool light);
    bool getHeadlight();

    virtual void draw3D(Aztec::MSelectMethod method, std::vector<Aztec::MSelectionItem> &items, float left, float top, float right = 0.0f, float bottom = 0.0f);
    /**
     * This draws any extra widgets, such as tool icons, head up displays, 
     * and other non-selectable things like that.
     */
    virtual void draw3DExtras();

    /**
     * Draws the manipulatrs. If Select is true, it draws using selection 
     * buffers, and returns 0 on none, x,y,z are 1,2,3 respectivley, 4 is 
     * the fourth yellow widget, normally parallel to the screen.
     */
    int drawManipulators(bool selecting);

    // AztecGLCanvas methods
    void draw3D();
    void doCameraTransform();
    const Aztec::Matrix3& getInverseTransform() const;
    const Aztec::MVector3& getViewNormal() const;
    const Aztec::MMatrix4& getModelView() const;
    float getScalingFactor(const Aztec::MVector3 &position);
    void getSelection(float left, float top, float right, float bottom, std::vector<Aztec::MSelectionItem> &items);
    void getSelection(float x, float y, std::vector<Aztec::MSelectionItem> &items);

    // MComponent methods
    bool onResize(int newWidth, int newHeight);

  protected:
    /**
     * Are we a perspective view? true if we are, false if we aren't.
     */
    bool perspectiveView;

    /**
     * This is the amount that we are zoomed in if we are in orthographic 
     * mode (not in perspective mode).
     */
    float zoomFactor;

    /**
     * This is the distance from our centre of interest we are if this 
     * is a perpsetive view.
     */
    float cameraDistance;

    float gateLeft, gateRight, gateTop, gateBottom;

    /**
     * This is the point where the camera is pointing at.
     */
    Aztec::MVector3 cameraFocus;

    /**
     * This is the orientation of the camera relative to our point of interest.
     */
    Aztec::MVector3 cameraRotation;

    mutable Aztec::Matrix3 inverseTransform;
    Aztec::MMatrix4 modelViewMatrix;
    mutable Aztec::MVector3 viewNormal;

    TextureModeEnum textureMode;
    ShadingModeEnum shadingMode;
    bool cullBackfaces;
    bool headlight;

    /**
     * This initialises the projection matrix, and leaves us in the 
     * Projection matrix mode for open gl. It will do different things
     * based upon wether we are in orhtographic or perpective mode.
     */
    void initProjectionMatrix(Aztec::MSelectMethod, float left, float top, float right, float bottom);

    /**
     * Draws a grid using the given basis.
     */
    void drawGrid(const Aztec::MVector3 &basisX, const Aztec::MVector3 &basisY, float gridRange, float gridSize, int gridMajorSpacing);

    void glRotateCamera() const;

    // MComponent methods    
    bool onMousePressed(const Aztec::MMouseEvent &event);


  };

  typedef Aztec::MRefCountedPtr<Aztec3DSceneCanvas> Aztec3DSceneCanvasPtr;
}

#endif

