-- hypov8
-- will animate a quake2 model into a kingpin usable model
-- load md2 body and weapon
-- select the 2 files. press convert

-- Option: fill time line tag names. starts at frame 0

-- quake2 animations are very limited compare dto kingpin. some odd animations will exist and need to be changed manualy
-- quake2 also uses only 1 model part. 
-- 		you can chose to export model as a complet part(eg body) but you must export a tiny triangle for the other parts (eg head/legs)
--		otherwise the model needs to be split into 3 parts and exported seperatly



utility QuakeMD2_To_Kingpin "Q2 to Kingpin"
(
	local array_kp_Anims=#()
	local array_Q2_Anims=#() 	-- txt file with 25 leg/body events (structure(start,end)
	local array_models=#() 		-- selected models to process
	local array_timeTags=#()	-- max 'time tag' names

	-- q2 animation file indexed names
	local Q2_STAND		= 1 as integer 
	local Q2_RUN		= 2 as integer 
	local Q2_ATTACK 	= 3 as integer 
	local Q2_PAIN1		= 4 as integer 
	local Q2_PAIN2		= 5 as integer 
	local Q2_PAIN3		= 6 as integer 
	local Q2_JUMP		= 7 as integer 
	local Q2_FLIP		= 8 as integer 
	local Q2_SALUTE		= 9 as integer 
	local Q2_TAUNT		= 10 as integer 
	local Q2_WAVE		= 11 as integer 
	local Q2_POINT		= 12 as integer 
	local Q2_CRSTAND	= 13 as integer 
	local Q2_CRWALK		= 14 as integer 
	local Q2_CRATTACK	= 15 as integer 
	local Q2_CRPAIN		= 16 as integer 
	local Q2_CRDEATH	= 17 as integer 
	local Q2_DEATH1		= 18 as integer 
	local Q2_DEATH2		= 19 as integer 
	local Q2_DEATH3		= 20 as integer 
	
	--"Taunt Animation"
	group "Replacement Animations"
	(
	
		radiobuttons UI_rBtn_attack "Runing Attack:"  align:#left  labels:#("RUN       (40->45)", "ATTACK (46>53)")  default:1	tooltip:("Running Attack:\n"+
												"Quake 2 does not have a attack while running\n\n"+
												"RUN\n show runnig but no attack.\nThis is ok if gun faces forward.\n"+
												"Or if you want to manualy edit the vertex later.\n\n" +
												"ATTACK\nWill have player sliding around but gun will shoot\n"	+
												"Use this if model has been animated to move while shooting")
		radiobuttons UI_rBtn_walk "Walk Attack:"  align:#left  labels:#("RUN    (40->45)", "ATTACK (46>53)")   default:1	tooltip:("Walking Attack:\n" +
												"Quake 2 does not have a attack while walking\n\n"+
												"RUN\n show runnig but no attack.\nThis is ok if gun faces forward.\n"+
												"Or if you want to manualy edit the vertex later.\n\n" +
												"ATTACK\nWill have player sliding around but gun will shoot\n"	+
												"Use this if model has been animated to move while shooting")
		radiobuttons UI_rBtn_strafe "Strafe:"  align:#left  labels:#("RUN    (40->45)", "ATTACK (46->53)")   default:1	tooltip:("Strafe:\n" +
												"Kingpin strafe and strafe/shoot use the same animation\n"+
												"Choose desired Q2 animation to use")																									
												
		radiobuttons UI_rBtn_taunt "Taunt:"  align:#left  labels:#("WAVE    (112->122)", "SALUTE  (84->94)")  default:1	tooltip:("Taunt:\n" +
												"Quake 2 has 4 taunts and kingpin has 3\n" + \
												"Choose desired Q2 animation to use")													
											
		radiobuttons UI_rBtn_ladder "Ladder:"  align:#left  labels:#("CROUCH  (135->155)", "JUMP     (66->71)")   default:1	tooltip:("Ladders:\n" +
												"Select best fit replacement")																								
	)
	checkbox UI_ChkBox_fNnames "Frame Names" checked:true  align:#left tooltip:"Add kingpin aimination names to the timeline"
	checkbox UI_ChkBox_x "Scale" across:2 checked:true  align:#left tooltip:"Scale model up to suit kingpin"
	spinner UI_Num_Scale "*" range:[0.10,10.00,1.40] scale:0.05  width:50 align:#left tooltip:(	"Quake 2 models are smaller than kingpin.\n" + 
																					"Recomended upscale is about 1.4x")																					
	button UI_btn_DoConversion "Convert"  across:2 align:#left height:22  width:90
	button UI_btn_Info "Info"   align:#right height:22  width:40
	
	on UI_btn_Info pressed do
	(
		str_Instructions = 	"Import a Quake 2 player model and weapon using the\n'KP Model Importer' tool.\n\n" + \
							"Set the desired conversion options.\n" + \
							"Select the player and weapon models.\n" + \
							"Press the 'Convert' button.\n\n" + \
							"Once model is finished. It will need extra vertex animations like run L/R, malee etc.\n" + \
							"You may need to use 'Bake Animation' with 'merge' enabled in\n'KP Model Exporter' tool to animate model/wep.\n" + \
							"Remember to Break the model after animating by using clone and deleting faces not unique to model.\n" + \
							"\n" + \
							"To animate the weapons, Create a new 'Point'.\n" + \
							"Attach 'Point' to the Q2 weapon using Animation->Constraints->Attatchment.\n" + \
							"Set frame to 0 and hit the 'set position' button.\n" + \
							"Select a big/flat surface on the gun.\n" + \
							"You can now import all the default kp weapons and move to the desired hand position.\n" + \
							"Use the 'select and link' tool to attatch weapons to 'point'."
							
		messageBox str_Instructions title:"Instructions" 
	)
	
	--q2 anims structure	
	struct frame_num_q2
	(	
		start,	total_fr
	)
	
	--kp anims structure
	struct frame_num_KP
	(	
		start,	end, body, -- <start frame> <end frame> <Q2 ani equilivent>
		tname, tframes -- timeline names
	)
	
	
	-- q2 animation set. start, total_fr
	fn f_SetupQ2Frames=
	(	
		append array_Q2_Anims (frame_num_q2 start:0		total_fr:40)	-- Q2_STAND
		append array_Q2_Anims (frame_num_q2 start:40	total_fr:6)		-- Q2_RUN
		append array_Q2_Anims (frame_num_q2 start:46	total_fr:8)		-- Q2_ATTACK
		append array_Q2_Anims (frame_num_q2 start:54	total_fr:4)		-- Q2_PAIN1
		append array_Q2_Anims (frame_num_q2 start:58	total_fr:4)		-- Q2_PAIN2
		append array_Q2_Anims (frame_num_q2 start:62	total_fr:4)		-- Q2_PAIN3
		append array_Q2_Anims (frame_num_q2 start:66	total_fr:6)		-- Q2_JUMP
		append array_Q2_Anims (frame_num_q2 start:72	total_fr:12)	-- Q2_FLIP
		append array_Q2_Anims (frame_num_q2 start:84	total_fr:11)	-- Q2_SALUTE
		append array_Q2_Anims (frame_num_q2 start:95	total_fr:17)	-- Q2_TAUNT
		append array_Q2_Anims (frame_num_q2 start:112	total_fr:11)	-- Q2_WAVE
		append array_Q2_Anims (frame_num_q2 start:123	total_fr:12)	-- Q2_POINT
		append array_Q2_Anims (frame_num_q2 start:135	total_fr:19)	-- Q2_CRSTAND
		append array_Q2_Anims (frame_num_q2 start:154	total_fr:6)		-- Q2_CRWALK
		append array_Q2_Anims (frame_num_q2 start:160	total_fr:9)		-- Q2_CRATTACK
		append array_Q2_Anims (frame_num_q2 start:169	total_fr:4)		-- Q2_CRPAIN
		append array_Q2_Anims (frame_num_q2 start:173	total_fr:5)		-- Q2_CRDEATH
		append array_Q2_Anims (frame_num_q2 start:178	total_fr:6)		-- Q2_DEATH1
		append array_Q2_Anims (frame_num_q2 start:184	total_fr:6)		-- Q2_DEATH2
		append array_Q2_Anims (frame_num_q2 start:190	total_fr:8)		-- Q2_DEATH3
	)
	
	-- kp animations set, start, end, q2 animation set
	fn f_SetupKPFrames=
	(
		append array_kp_Anims (frame_num_KP start:0  	end:31		body:Q2_STAND 		tname: "tgun_rdy_"			tframes: 32	) 	--01	--	ok
		append array_kp_Anims (frame_num_KP start:32	end:36		body:Q2_ATTACK 		tname: "tg_shoot_"			tframes: 5	)	--02	--	ok
		append array_kp_Anims (frame_num_KP start:37	end:46		body:Q2_WAVE 		tname: "tg_bird_"			tframes: 10	)	--03	--	ok
		append array_kp_Anims (frame_num_KP start:47	end:62		body:Q2_TAUNT 		tname: "tg_crch_grab_"		tframes: 16	)	--04	--	ok
		append array_kp_Anims (frame_num_KP start:63	end:77		body:Q2_FLIP 		tname: "tg_chin_flip_"		tframes: 15	)	--05	--	ok
		append array_kp_Anims (frame_num_KP start:78	end:100		body:Q2_STAND 		tname: "1pstl_rdy_"			tframes: 23	)	--06	--	ok *missing* pistol
		append array_kp_Anims (frame_num_KP start:101	end:104		body:Q2_ATTACK 		tname: "p_std_shoot_"		tframes: 4	)	--07	--	ok *missing* pistol
		append array_kp_Anims (frame_num_KP start:105	end:114		body:Q2_RUN 		tname: "walk_gdown_"		tframes: 10	)	--08	--	ok *missing* slow	
		append array_kp_Anims (frame_num_KP start:115	end:124		body:Q2_RUN 		tname: "walk_tg_sht_"		tframes: 10	)	--09	--	*missing* slot+walking
		append array_kp_Anims (frame_num_KP start:125	end:130		body:Q2_RUN 		tname: "run_tg_sht_"		tframes: 6	)	--10	--	--*missing* run
		append array_kp_Anims (frame_num_KP start:131	end:136		body:Q2_RUN 		tname: "rsd_tg_run_"		tframes: 6	)	--11	--	ok~ *missing* side	
		append array_kp_Anims (frame_num_KP start:137	end:142		body:Q2_RUN 		tname: "lsd_tg_run_"		tframes: 6	)	--12	--	ok~ *missing* side	
		append array_kp_Anims (frame_num_KP start:143	end:152		body:Q2_RUN 		tname: "p_walk_sht_"		tframes: 10	)	--13	--	--*missing* slow+walk
		append array_kp_Anims (frame_num_KP start:153	end:158		body:Q2_RUN 		tname: "p_run_shoot_"		tframes: 6	)	--14	--	--*missing* running	pistol
		append array_kp_Anims (frame_num_KP start:159	end:164		body:Q2_RUN 		tname: "p_rside_run_"		tframes: 6	)	--15	--	ok~ *missing* sidestep
		append array_kp_Anims (frame_num_KP start:165	end:170		body:Q2_RUN 		tname: "p_lside_run_"		tframes: 6	)	--16	--	ok~ *missing* sidestep
		append array_kp_Anims (frame_num_KP start:171	end:189		body:Q2_STAND 		tname: "melee_rdy_"			tframes: 19	)	--17	--	ok *missing*
		append array_kp_Anims (frame_num_KP start:190	end:196		body:Q2_ATTACK 		tname: "melee1_"			tframes: 7	)	--18	--	--*missing* crowbar
		append array_kp_Anims (frame_num_KP start:197	end:202		body:Q2_ATTACK 		tname: "melee2_"			tframes: 6	)	--19	--	--*missing* crowbar2
		append array_kp_Anims (frame_num_KP start:203	end:208		body:Q2_RUN 		tname: "run_melee_"			tframes: 6	)	--20	--	ok *missing* crowbar
		append array_kp_Anims (frame_num_KP start:209	end:214		body:Q2_RUN 		tname: "run_gun_dn_"		tframes: 6	)	--21	--	ok
		append array_kp_Anims (frame_num_KP start:215	end:221		body:Q2_JUMP 		tname: "jump_"				tframes: 7	)	--22	--	ok
		append array_kp_Anims (frame_num_KP start:222	end:230		body:Q2_CRSTAND 	tname: "clmb_loop_"			tframes: 9	)	--23	--	--*missing* 1frame crch?
		append array_kp_Anims (frame_num_KP start:231	end:249		body:Q2_DEATH1 		tname: "death1_"			tframes: 19	)	--24	--	ok 19 frames
		append array_kp_Anims (frame_num_KP start:250	end:265		body:Q2_DEATH2 		tname: "death2_"			tframes: 16	)	--25	--	ok 16 frames
		append array_kp_Anims (frame_num_KP start:266	end:293		body:Q2_DEATH3 		tname: "death3_"			tframes: 28	)	--26	--	ok 28 frames
		append array_kp_Anims (frame_num_KP start:294	end:306		body:Q2_DEATH2 		tname: "death4_"			tframes: 13	)	--27	--	ok 13 frames
		append array_kp_Anims (frame_num_KP start:307	end:333		body:Q2_CRSTAND 	tname: "tg_crch_rdy_"		tframes: 27	)	--28	--	ok
		append array_kp_Anims (frame_num_KP start:334	end:339		body:Q2_CRATTACK 	tname: "crouch_shoot_"		tframes: 6	)	--29	--	ok	
		append array_kp_Anims (frame_num_KP start:340	end:344		body:Q2_CRWALK 		tname: "crch_walk_"			tframes: 5	)	--30	--	ok	
		append array_kp_Anims (frame_num_KP start:345	end:362		body:Q2_CRSTAND 	tname: "1p_crch_rdy_"		tframes: 18	)	--31	--	ok *missing*
		append array_kp_Anims (frame_num_KP start:363	end:367		body:Q2_CRATTACK 	tname: "p_crch_sht_"		tframes: 5	)	--32	--	ok *missing*
		append array_kp_Anims (frame_num_KP start:368	end:373		body:Q2_CRWALK 		tname: "p_crch_walk_"		tframes: 6	)	--33	--	ok *missing*
		append array_kp_Anims (frame_num_KP start:374	end:385		body:Q2_CRDEATH 	tname: "crouch_death_"		tframes: 12	)	--34	--	ok
	)
	

	--set time tags for kp
	fn f_setTimeTags =	
	(
		if UI_ChkBox_fNnames.checked then
		(	
			FrameTagManager.ResetFrameTags()

			local fTime = 0 --3dsmax frame number
			for index=1 to  (array_kp_Anims.count ) do
			(
				-- per animation counter
				for fNum = 1 to array_kp_Anims[index].tframes do
				(
					local tname = array_kp_Anims[index].tname + fNum as string
					FrameTagManager.CreateNewTag tname fTime
					fTime += 1			
				)	
			)		
		)
	)	
	
	

	--tween frame between start/end of an animation sequence. helps with frame count differnces
	fn get_tagent_type_fn key_f q2_current_f q2_total_f =
	(
		if (q2_current_f == 0) then --first frame
		(
			key_f.inTangentType = #step
			key_f.outTangentType =#linear
		)
		else if q2_current_f >= (q2_total_f - 1) then --last frame
		(
			key_f.inTangentType = #linear
			key_f.outTangentType = #step
		)
		else	--any frame between
		(
			key_f.inTangentType = #linear 
			key_f.outTangentType = #linear
		)
	)
	
	--
	fn f_moveModelKeys aObjects_f =
	(
		--clearSelection()
		print("moving ANIMATION SET keys----- PLEASE WAIT!!!")	
		
		--loop through each selected object
		for sourceObj in aObjects_f do
		(	
			local frames_total_q2, frameID_start_q2, frameID_end_q2, tempname	
			local count = 0	--animation counter (kp is 25)
			
			--create a duplicate object
			tempname = uniqueName ("KP_" + sourceObj.name + "_")
			targetObj = snapshot sourceObj name:tempname
			convertTo targetObj Editable_Mesh
			targetObj.controller = sourceObj.controller
			animateVertex targetObj #all
			InstanceMgr.MakeControllersUnique targetObj targetObj.controller #prompt 
			
			masterCtrl = targetObj[4][1]
			deleteKeys masterCtrl #allKeys --todo does root work?

			
			
			-- loop through all kp animation sequences
			for aniset_kp in array_kp_Anims do
			(
				local frame_start_kp = aniset_kp.start as integer
				local frame_end_kp = aniset_kp.end as integer	
				local frames_total_kp = (frame_end_kp - frame_start_kp + 1) as integer
				local q2_aniIndex = aniset_kp.body				
				local deathanim = false -- last frame is duplicated to fill timeline?
				count += 1
				
				progressUpdate (100.0 / 34 * count)

				
				---------------------
				-- varable animations
				---------------------
				-- attack/run
				if UI_rBtn_attack.state == 2 and  (count == 10 or count == 14  or count == 20) then -- run_tg_sht_ + p_run_shoot_
					q2_aniIndex =  Q2_ATTACK		
				-- attack/walk
				if UI_rBtn_walk.state == 2 and  (count == 9 or count == 13) then -- walk_tg_sht + p_walk_sht
					q2_aniIndex =  Q2_ATTACK	
	
				-- strafe
				if UI_rBtn_strafe.state == 2 and (count == 11 or count == 12 or  count == 15 or count == 16 ) then
					q2_aniIndex =  Q2_ATTACK

				-- taunt
				if UI_rBtn_taunt.state == 2 and q2_aniIndex == Q2_WAVE then
					q2_aniIndex =  Q2_SALUTE	
					
				-- ladders
				if UI_rBtn_ladder.state == 2 and  count == 23 then
					q2_aniIndex =  Q2_JUMP	
					
				-- end varable animations
				-------------------------	
				
				
				frameID_start_q2 = (array_Q2_Anims[q2_aniIndex].start) as integer
				frameID_end_q2 = (frameID_start_q2 + array_Q2_Anims[q2_aniIndex].total_fr - 1) as integer
				frames_total_q2 = array_Q2_Anims[q2_aniIndex].total_fr as integer				
				
				
				--make animations exactly frame for frame
				if 	q2_aniIndex == Q2_CRDEATH or q2_aniIndex == Q2_DEATH1 or 
					q2_aniIndex == Q2_DEATH2 or q2_aniIndex == Q2_DEATH3 or
					q2_aniIndex == Q2_WAVE  or 	q2_aniIndex == Q2_TAUNT or 
					/*q2_aniIndex == Q2_FLIP or */		q2_aniIndex == Q2_SALUTE then
						deathanim = true
				
				if 	q2_aniIndex == Q2_WAVE or q2_aniIndex == Q2_TAUNT or q2_aniIndex == Q2_SALUTE then /*q2_aniIndex == Q2_FLIP or*/ 
					frames_total_q2 -= 1

				-- get every q2 keyframe. paste to kp frame%
				for q2_key = 0 to  frames_total_q2 do
				(
					local offset_q2
					local time_kp
					local time_q2
					
					if q2_key == 0 then
					(
						time_kp = frame_start_kp
						time_q2	= 	frameID_start_q2				
					)
					else	if (q2_key == (frames_total_q2 - 1)) and not deathanim then 
					(
						time_kp = frame_end_kp
						time_q2	= 	frameID_end_q2							
					)
					else if (q2_key <= (frames_total_q2 - 1)) then
					(		
						local tween_fr =	( (frames_total_kp - 1 as Double) / (frames_total_q2 - 1 as Double) ) as Double --was (frames_total_q2--1)
						tween_fr *= (q2_key ) as Double 
						if deathanim then 
							tween_fr = q2_key as integer
						time_kp = (frame_start_kp + tween_fr)  as float
						time_q2 = (frameID_start_q2 + q2_key )	 as integer	
					)
					else	if deathanim then	-- death animations, 1 extra last frame
					(	
						--print("--using death anim--")
						time_kp = frame_end_kp  as integer
						time_q2 = (frameID_start_q2 + (q2_key - 1))  as integer
					)
					else
					(
						exit -- non death animations
					) -- end q2_keys setup
					
					
					-- copy q2 to kp verts 
					for i in 1 to targetObj.numVerts do 
					(
						k = addNewKey masterCtrl[i].controller time_kp
						get_tagent_type_fn k q2_key frames_total_q2 
						k.value = at time time_q2 in coordSys sourceObj getVert sourceObj i
					)	
				)
-----------------------------------					
				--exit	-- debug.. only do 1 animation set
-----------------------------------	
			)
			
			-- scale model
			if UI_ChkBox_x.checked then
			(
				local kp_floor_matrix =	(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,-24])		--kp floor  origin
				local resizeVal = UI_Num_Scale.value

				about kp_floor_matrix scale targetObj [resizeVal, resizeVal, resizeVal]
			)	
		) -- end objects
		
		--todo delet q2 keys
		--todo set tween type
		print("----- moving ANIMATION SET keys Done -----")
	) --end function copy keys
	
	fn f_objectsAsGroups =	
	(
		array_models=#()
		for obj in selection do
		(
			append array_models obj		
			print("----- adding selections obj -----")
		) -- end adding each mesh object to array

	)--end function set model groups
	
	-- inital loading of script... build arrays
	on QuakeMD2_To_Kingpin open do 
	(		
		f_SetupQ2Frames()
		f_SetupKPFrames()
	) --end on load script
	
	-- ui button Convert
	on UI_btn_DoConversion pressed do
	(
		progressStart ("Converting Model...")
		progressUpdate (5)

		f_objectsAsGroups()
		if (array_models.count >= 1) then
		(	
			animationrange = interval 0 385		
			f_setTimeTags()
			f_moveModelKeys array_models
		)
		else
		(
			messagebox("ERROR.. no models selected")
		)

		progressEnd()
		
		max views redraw
	)-- end button do convert

) -- end utility