#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "tga.h"

#define EXPORT __declspec (dllexport)

typedef struct image_list_t *ilist_t;
typedef struct image_list_t
{
        unsigned long width;
        unsigned long height;
        unsigned long offset;
        ilist_t nextim;
} image_list_t;

typedef struct entry_list_t *elist_t;
typedef struct entry_list_t {
  char name[256]; //name of the entry
  unsigned long size; //size, must be correct for entry saving, not for images
  unsigned long csize; //compressed size
  unsigned long comptype; //compression type, 0 = none, 1 = Daikatana RLE, 2 = deflate
  unsigned long offset; // offset to file data or image data (past the header and palette)
  unsigned long format; //0 = regular image, 1 = art, 2 = 16-bit, ...
  unsigned long palette_offset; //Offset to palette data (if exists), -1 = no palette
  unsigned long palette_type; // 0 = regular 768, 1 = bmp 1024, ...
  unsigned long image_offset; //Offset to raw image data
  unsigned long width; // 0 if not image
  unsigned long height; // 0 if not image
  unsigned long extra; // for extra stuff used with plugins (output size when retrieving data)
  unsigned long numtex; // 1 = normal image, 0 if not image, > 1 for textures with more than one images
  elist_t next;
  ilist_t nextim;
} entry_list_t;

elist_t mapped = NULL;
HANDLE hentry;

#pragma argsused
int WINAPI DllMain(HINSTANCE hinst, DWORD reason, PVOID orgh)
{
        switch (reason)
        {
                case DLL_PROCESS_DETACH:
                        UnmapViewOfFile(mapped);
                        CloseHandle(hentry);
                break;
        }

        return 1;
}

// how many different extensions are supported
EXPORT short CALLBACK get_ext_count (void)
{
        return 1;
}

#pragma argsused
// extensions that this plugin wants to handle
EXPORT char * CALLBACK get_ext (int number)
{
        return "tga";
}

#pragma argsused
// returns a short description of extension
EXPORT char * CALLBACK get_format_desc (int number)
{
        return "TGA image file";
}

#pragma argsused
// Let's determine if we can recognize the file
EXPORT elist_t CALLBACK open (HWND hwnd, char *fullname, char *filename, int size, int offset)
{
        FILE *sourcef;
        char error[256];
        HANDLE hentry;
        tgaheader_t tga;

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                wsprintf (error, "Couldn't open file %s !", fullname);
                MessageBox(hwnd, error, "TGA Plug-in error", MB_OK);
                return NULL;
        }
        fseek(sourcef, 0, 0);
        fread(&tga, sizeof(tgaheader_t), 1, sourcef);

        //wsprintf (error, "Width: %i\nHeight: %i\nType: %i\nPixel: %i", tga.Width, tga.Height, tga.ImageType, tga.PixelDepth);
        //MessageBox(hwnd, error, "TGA Plug-in message", MB_OK);

        hentry = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, sizeof(entry_list_t), NULL);
        if (hentry != NULL)
        {
        		mapped = (elist_t) MapViewOfFile(hentry, FILE_MAP_WRITE, 0, 0, 0);
        }
        else return NULL;
        if (mapped == NULL)
        {
            CloseHandle(hentry);
            fclose(sourcef);
         	return NULL;
        }

        strcpy(mapped->name, filename);
        mapped->width = tga.Width;
        mapped->height = tga.Height;
        mapped->offset = offset;
        mapped->next = NULL;
        if (size == 0)
        {
        		fseek(sourcef, 0, 2);
            mapped->size = ftell(sourcef);
        }
        else mapped->size = size;
        fclose(sourcef);
         
        if (tga.PixelDepth == 24 && tga.ImageType == 2)
        {
        		mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
         	mapped->format = 5;
        }
        else if (tga.PixelDepth == 16 && tga.ImageType == 10)
        {
        		mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
            mapped->format = 12;
        }
        else if (tga.PixelDepth == 24 && tga.ImageType == 10)
        {
        		mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
            mapped->format = 14;
        }
        else if (tga.PixelDepth == 8 && tga.ImageType == 1)
        {
            mapped->palette_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
            mapped->palette_type = 3;
         	mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength + 768;
         	mapped->format = 7;
        }
        else if (tga.PixelDepth == 8 && tga.ImageType == 9)
        {
        		mapped->palette_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
            mapped->palette_type = 3;
            mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength + 768;
            mapped->format = 13;
        }
        else if (tga.PixelDepth == 16 && tga.ImageType == 2)
        {
            mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength ;
         	mapped->format = 2;
        }
        else if (tga.PixelDepth == 32 && tga.ImageType == 2)
        {
            mapped->image_offset = mapped->offset + sizeof(tgaheader_t) + tga.IDLength;
         	mapped->format = 6;
        }
        else {
            UnmapViewOfFile(mapped);
            CloseHandle(hentry);
            return NULL;
        }

        return mapped;  // we are in business...
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_entry (void)
{
        UnmapViewOfFile(mapped);
        mapped = NULL;
        CloseHandle(hentry);
}
//---------------------------------------------------------------------------
// returns a short description string of the plug-in
EXPORT char * CALLBACK get_desc (void)
{
        return "Truevision Targa";
}
//---------------------------------------------------------------------------
// displaying the "About" -dialog
EXPORT void CALLBACK plugin_info (HWND hwnd)
{
        MessageBox(hwnd, "Just a simple plug-in example...", "TGA Plug-in", MB_OK);
}
//---------------------------------------------------------------------------

