//---------------------------------------------------------------------------
// Command & Conquer CPS image file plug-in
//---------------------------------------------------------------------------
#include <windows.h>
#include <stdio.h>           
#include <stdlib.h>
//---------------------------------------------------------------------------
#define EXPORT __declspec (dllexport)
//---------------------------------------------------------------------------
typedef struct image_list_t *ilist_t;
typedef struct image_list_t
{
        unsigned long width;
        unsigned long height;
        unsigned long offset;
        ilist_t nextim;
} image_list_t;
//---------------------------------------------------------------------------
typedef struct entry_list_t *elist_t;
typedef struct entry_list_t {
  char name[256]; //name of the entry
  unsigned long size; //size, must be correct for entry saving, not for images
  unsigned long csize; //compressed size
  unsigned long comptype; //compression type, 0 = none, 1 = Daikatana RLE, 2 = deflate
  unsigned long offset; // offset to file data or image data (past the header and palette)
  unsigned long format; //0 = regular image, 1 = art, 2 = 16-bit, ...
  unsigned long palette_offset; //Offset to palette data (if exists), -1 = no palette
  unsigned long palette_type; // 0 = regular 768, 1 = bmp 1024, ...
  unsigned long image_offset; //Offset to raw image data
  unsigned long width; // 0 if not image
  unsigned long height; // 0 if not image
  unsigned long extra; // for extra stuff used with plugins (output size when retrieving data)
  unsigned long numtex; // 1 = normal image, 0 if not image, > 1 for textures with more than one images
  elist_t next;
  ilist_t nextim;
} entry_list_t;
//---------------------------------------------------------------------------
elist_t mapped = NULL;
char * bitmap = NULL;
HANDLE hbitmap;
HANDLE hentry;
//---------------------------------------------------------------------------
typedef struct cps_t
{
   unsigned short size;  // File size - 2
   unsigned short unknown;  //Always 0004h
   unsigned short imsize; //Size of uncompressed image (always 0FA00h)
	long palette; //Is there a palette ?
} cps_t;
//---------------------------------------------------------------------------
#pragma argsused
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*nothing)
{
        switch (reason)
        {
                case DLL_PROCESS_DETACH:
                        UnmapViewOfFile(mapped);
                        UnmapViewOfFile(bitmap);
                        CloseHandle(hentry);
                        CloseHandle(hbitmap);
                break;
        }

        return 1;
}
//---------------------------------------------------------------------------
// how many different extensions are supported
EXPORT short CALLBACK get_ext_count (void)
{
        return 1;
}
//---------------------------------------------------------------------------
// extensions that this plugin wants to handle
#pragma argsused
EXPORT char * CALLBACK get_ext (int number)
{
        return "cps";
}
//---------------------------------------------------------------------------
// returns a short description of extension
#pragma argsused
EXPORT char * CALLBACK get_format_desc (int number)
{
        return "CC CPS image file";
}
//---------------------------------------------------------------------------
// Let's determine if we can recognize the file
EXPORT elist_t CALLBACK open (HWND hwnd, char *fullname, char *filename, int size, int offset)
{
        cps_t cps;
        FILE *sourcef;
        char error[256];

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                wsprintf (error, "Couldn't open file %s !", fullname);
                MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);
                return NULL;
        }
        fseek(sourcef, offset, 0);
        fread(&cps, sizeof(cps_t), 1, sourcef);

        //wsprintf (error, "Size: %i\nunknown: %i\nimsize: %i\npalette: %li", cps.size, cps.unknown, cps.imsize, cps.palette);
        //MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);

        if ((cps.unknown != 3 && cps.unknown != 4) || cps.imsize != 64000)
        {
                wsprintf (error, "Not a proper CPS file!\nUnknown: %i", cps.unknown);
                MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);
                fclose(sourcef);
                return NULL;  //format not supported
        }
        else {
                hentry = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, sizeof(entry_list_t), NULL);
                if (hentry != NULL)
                {
                        mapped = (elist_t) MapViewOfFile(hentry, FILE_MAP_WRITE, 0, 0, 0);
                }
                else return NULL;
                if (mapped != NULL)
                {
                        mapped->format = 1000; //plug-in format for images
                        mapped->width = 320;
                        mapped->height = 200;
                        mapped->extra = 8; //we want GFE to create an 8-bit image
                        if (size == 0) //cps file was not in a package
                        {
        		        					fseek(sourcef, 0, 2);
                                mapped->size = ftell(sourcef);
                        }
                        fclose(sourcef);
                        mapped->offset = offset;
                        mapped->image_offset = mapped->offset + sizeof(cps_t);
                        strcpy(mapped->name, filename);
                        if (cps.palette == 0x03000000) //we have a palette here!
                        {
                                mapped->palette_offset = mapped->image_offset;
                                mapped->image_offset = mapped->image_offset + 768;
                                mapped->palette_type = 4;
                        }
                }
                else CloseHandle(hentry);
                return mapped;  // we are in business...
        }
}
//---------------------------------------------------------------------------
// returns a short description string of the file
EXPORT char * CALLBACK get_desc (void)
{
        return "Westwood CPS image";
}
//---------------------------------------------------------------------------
// displaying the "About" -dialog
EXPORT void CALLBACK plugin_info (HWND hwnd)
{
        MessageBox(hwnd, "CPS plug-in for GFE.\nOriginal plug-in by A. Ahlstrm\nImprovements and the 03h compression method by Compuart.", "CPS Plug-in", MB_OK);
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_entry (void)
{
        UnmapViewOfFile(mapped);
        mapped = NULL;
        CloseHandle(hentry);
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_bitmap_data (void)
{
        UnmapViewOfFile(bitmap);
        bitmap = NULL;
        CloseHandle(hbitmap);
}
//---------------------------------------------------------------------------
#pragma argsused
unsigned char * decode_80h (int ssiz, int dsiz, unsigned char *dest, HWND hwnd, FILE *fileptr)
{
	unsigned char *source;
   unsigned char b7, b6, b, com, two[2];
   unsigned short posit, count;
	//Source and Dest are the two buffers
   int SP = 0, DP = 0, i;

   source = malloc (ssiz);
   if (source == NULL || dest == NULL)
   {
   	if (source) free(source);
      if (dest) free(dest);
      return NULL;
   }
   fread(source, ssiz, 1, fileptr);

   do {
    com = source[SP];
    SP++;
    if (SP >= ssiz) break;
    b7 = (unsigned char)((com & 0x80) >> 7);  //Com shr 7;  //b7 is bit 7 of Com

    switch (b7)
    {
    	case 0 :  //copy command (2)
      	//Count is bits 4-6 + 3
      	count = (unsigned short) (((com & 0x7F) >> 4) + 3); //(Com and $7F) shr 4 + 3;
         //Position is bits 0-3, with bits 0-7 of next byte
         posit = (unsigned short) (((com & 0x0F) << 8) + source[SP]); //(Com and $0F) shl 8 + Source[SP];
         SP++;
         if (SP >= ssiz) break;
         //Starting pos=Cur pos. - calculated value
         posit = (unsigned short) (DP - posit);
         for(i=posit;i<posit+count;i++) ///for i:=Posit to Posit+Count-1 do
         {
            /*if (DP == 7466) {
               wsprintf(v_viesti, "Hep: %i %li %li", dest[i], i, source[SP]);
               dest[0] = dest[i];
            	MessageBox(hwnd, v_viesti, PNAME, MB_OK);   //error here??????????????????
            }*/
            if (i >= ssiz) break;
            dest[DP] = dest[i];
            DP++;
            if (DP >= dsiz) break;
         }
         break;

      case 1 :  //Check bit 6 of Com
            b6 = (unsigned char)((com & 0x40) >> 6); //(Com and $40) shr 6;

            switch (b6)
            {
            	case 0 : //Copy as is command (1)
               	count = (unsigned short) (com & 0x3F); ///Com and $3F;  //mask 2 topmost bits
                  if (count == 0) break; //EOF marker
                  for (i=1;i<count+1;i++)  //  for i:=1 to Count do
                  {
                  	dest[DP] = source[SP];
                     DP++;
                     SP++;
                     if (SP >= ssiz) break;
                     if (DP >= dsiz) break;
                   }
               break;

              	case 1 : //large copy, very large copy and fill commands    //clear
               	//Count = (bits 0-5 of Com) +3
                  //if Com=FEh then fill, if Com=FFh then very large copy
                  count = (unsigned short) (com & 0x3F); //com and $3F;
                  if (count < 0x3E) //large copy (3)
                  {
                     count = (unsigned short) (count + 3);
                      //Next word = pos. from start of image
                     two[0] = source[SP];
                     two[1] = source[SP+1];
                  	//posit = /*(unsigned short)*/ (source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                     posit = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff))); //SHORT_ORDER(*two);
   						SP = SP + 2;
                     if (SP >= ssiz) break;
                     for (i=posit;i<posit+count;i++) //for i:=Posit to Posit+Count-1 do
                     {
                     	dest[DP] = dest[i];
                        if (i >= dsiz) break;
                        DP++;
                        if (DP >= dsiz) break;
                     }
               	}
                  else if (count == 0x3F)  //very large copy (5)
                  {
                  	//next 2 words are Count and Pos
                     two[0] = source[SP];
                     two[1] = source[SP+1];
                     count = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                  	//count = /*(unsigned short)*/(source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                     two[0] = source[SP+2];
                     two[1] = source[SP+3];
                     //posit = /*(unsigned short)*/(source[SP+2] | (source [SP+3] << 8)); //Word(Source[SP+2]);
                     posit = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                     SP = SP + 4;
                     if (SP >= ssiz) break;
                     for(i=posit;i<posit+count;i++) // for i:=Posit to Posit+Count-1 do
                     {
                        if (i >= dsiz) break;
                     	dest[DP] = dest[i];

                        DP++;
                        if (DP >= dsiz) break;
                     }
                  } else {     //Count=$3E, fill (4)
                      //Next word is count, the byte after is color
                      two[0] = source[SP];
                      two[1] = source[SP+1];
                      count = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                      //count = /*(unsigned short)*/(source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                      SP = SP + 2;
                      if (SP >= ssiz) break;
                      b = source[SP];
                      SP++;
                      if (SP >= ssiz) break;
                      for (i=0;i<count;i++) //for i:=0 to Count-1 do
                      {
                      		dest[DP] = b;

                           DP++;
                           if (DP >= dsiz) break;
                      }
                  }
					}
			}
    }  while (SP < ssiz && DP < dsiz);

    free(source);
    return dest;
}
#pragma argsused
unsigned char * decode_80_03h (int ssiz, int dsiz, unsigned char *dest, HWND hwnd, FILE *fileptr)
{
	unsigned char *source;
   unsigned char com,two[2];
   unsigned short count;
	//Source and Dest are the two buffers
   int SP = 0, DP = 0, i;

   source = malloc (ssiz);
   if (source == NULL || dest == NULL)
   {
   	if (source) free(source);
      if (dest) free(dest);
      return NULL;
   }
   fread(source, ssiz, 1, fileptr);

   do {
    com = source[SP];
    SP++;
    if (SP >= ssiz) break;
    if (com == 0x00)
    {
			two[0] = source[SP];
			two[1] = source[SP+1];
			count = (unsigned short)(((two[0] & 0xff) << 8) | (two[1] & 0xff));
    		SP = SP + 2;
         if (SP >= ssiz) break;
         for(i=0;i<count;i++)
         {
             	dest[DP] = source[SP];
               DP++;
               if (DP >= dsiz) break;
         }
         SP++;
         if (SP >= ssiz) break;
    }
    else if (com < 0x80)
    {
      	count = (unsigned short) (com & 0xFF);
         for (i=0;i<count;i++)
         {
             	dest[DP] = source[SP];
               DP++;
               SP++;
               if (SP >= ssiz) break;
               if (DP >= dsiz) break;
         }
    }
    else
    {
      	count = (unsigned short) (0x100 - com);
         for (i=0;i<count;i++)
         {
             	dest[DP] = source[SP];
               DP++;
               if (DP >= dsiz) break;
         }
         SP++;
         if (SP >= ssiz) break;

    }
   } while (SP < ssiz && DP < dsiz);

free(source);
return dest;
}
//---------------------------------------------------------------------------
// Let's determine if we can recognize the file
#pragma argsused
EXPORT char * CALLBACK get_bitmap_data (HWND hwnd, char *fullname, int offset, int number)
{
        cps_t cps;
        FILE *sourcef;
        char error[256];
        unsigned char *temp;
        int i, z, y, j;

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                wsprintf (error, "Couldn't open file %s !", fullname);
                MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);
                return NULL;
        }
        fseek(sourcef, offset, 0);
        fread(&cps, sizeof(cps_t), 1, sourcef);
        fseek(sourcef, offset + sizeof(cps_t), 0);
        if (cps.palette == 0x03000000) //we have a palette here!
        {
                fseek(sourcef, offset + sizeof(cps_t) + 768, 0);
                //wsprintf (error, "Seeking: %li\nNumber: %li\nOffset: %li", ftell(sourcef), number, offset);
                //MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);
        }

        //wsprintf (error, "Size: %i\nunknown: %i\nimsize: %i\npalette: %li", cps.size, cps.unknown, cps.imsize, cps.palette);
        //MessageBox(hwnd, error, "CPS Plug-in error", MB_OK);

        temp = (unsigned char *) malloc(cps.imsize);
        if (temp == NULL)
        {
        		fclose(sourcef);
            return NULL;
        }
        hbitmap = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, cps.imsize, NULL);
        if (hbitmap != NULL)
        {
                bitmap = (char *) MapViewOfFile(hbitmap, FILE_MAP_WRITE, 0, 0, 0);
                if (bitmap == NULL)
                {
                  CloseHandle(hbitmap);
                	free(temp);
        				fclose(sourcef);
            		return NULL;
                }
        }
        else {
        		free(temp);
        		fclose(sourcef);
            return NULL;
        }
        if (cps.unknown == 4)
        {
                temp = decode_80h (320*200, 320*200, temp, hwnd, sourcef);
        }
        else if (cps.unknown == 3)
        {
                temp = decode_80_03h (320*200, 320*200, temp, hwnd, sourcef);
        }
        else
        {
                return NULL;//file format unknown
        }
        z = 0;  //flip
        i = 320 * 200;
        for (y = 200; y > 0; y--)
        {
      		i = i - 320;
            for (j=0;j<320;j++)
            {
            	bitmap[i+j] = temp[z];
               z++;
            }
        }

        free(temp);
        fclose(sourcef);
        return bitmap;
}
