#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

#define EXPORT __declspec (dllexport)

typedef struct image_list_t *ilist_t;
typedef struct image_list_t
{
        unsigned long width;
        unsigned long height;
        unsigned long offset;
        ilist_t nextim;
} image_list_t;

typedef struct entry_list_t *elist_t;
typedef struct entry_list_t {
  char name[256]; //name of the entry
  unsigned long size; //size, must be correct for entry saving, not for images
  unsigned long csize; //compressed size
  unsigned long comptype; //compression type, 0 = none, 1 = Daikatana RLE, 2 = deflate
  unsigned long offset; // offset to file data or image data (past the header and palette)
  unsigned long format; //0 = regular image, 1 = art, 2 = 16-bit, ...
  unsigned long palette_offset; //Offset to palette data (if exists), -1 = no palette
  unsigned long palette_type; // 0 = regular 768, 1 = bmp 1024, ...
  unsigned long image_offset; //Offset to raw image data
  unsigned long width; // 0 if not image
  unsigned long height; // 0 if not image
  unsigned long extra; // for extra stuff used with plugins (output size when retrieving data)
  unsigned long numtex; // 1 = normal image, 0 if not image, > 1 for textures with more than one images
  elist_t next;
  ilist_t nextim;
} entry_list_t;

elist_t mapped = NULL;
HANDLE hentry;
char *pPalette = NULL;
HANDLE hpalette;

typedef struct cps_t
{
   unsigned short size;  // File size - 2
   unsigned short unknown;  //Always 0004h
   unsigned short imsize; //Size of uncompressed image (always 0FA00h)
	long palette; //Is there a palette ?
} cps_t;

EXPORT void CALLBACK delete_entry (void);

#pragma argsused
int WINAPI DllMain(HINSTANCE hinst, DWORD reason, PVOID orgh)
{
        switch (reason)
        {
                case DLL_PROCESS_DETACH:
                        UnmapViewOfFile(mapped);
                        CloseHandle(hentry);
                        UnmapViewOfFile(pPalette);
        						CloseHandle(hpalette);
                break;
        }

        return 1;
}
//---------------------------------------------------------------------------
// how many different extensions are supported
EXPORT short CALLBACK get_ext_count (void)
{
        return 1;
}
//---------------------------------------------------------------------------
#pragma argsused
// extensions that this plugin wants to handle
EXPORT char * CALLBACK get_ext (int number)
{
	return "col";
}
//---------------------------------------------------------------------------
#pragma argsused
// returns a short description of extension
EXPORT char * CALLBACK get_format_desc (int number)
{
        return "Kyrandia COL Palette";
}
//---------------------------------------------------------------------------
#pragma argsused
// Let's determine if we can recognize the file
EXPORT elist_t CALLBACK open (HWND hwnd, char *fullname, char *filename, int size, int offset)
{
        cps_t cps;
        FILE *sourcef;
        char error[256];
        long pal_length, pal_offs;

        sourcef = fopen (fullname, "rb");
        if (sourcef == NULL)
        {
                //wsprintf (error, "Couldn't open file %s !", fullname);
                //MessageBox(hwnd, error, "COL Plug-in error", MB_OK);
                return NULL;
        }

        //fseek(sourcef,0L,SEEK_END);
	     //pal_length = ftell(sourcef);  //(let's use 'size' instead)
        if (size == 0) {
        		fseek(sourcef, 0L, SEEK_END);
            pal_length = ftell(sourcef);
            pal_offs = 0;
        } else {
        	pal_length = size;
        	pal_offs = offset;
        }

        hentry = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, sizeof(entry_list_t), NULL);
        if (hentry != NULL)
        {
        		mapped = (elist_t) MapViewOfFile(hentry, FILE_MAP_WRITE, 0, 0, 0);
        }
        else return NULL;
        if (mapped == NULL)
        {
            CloseHandle(hentry);
            fclose(sourcef);
         	return NULL;
        }

        if (pal_length != 0x300)
        { //palette is probably a Westwood compressed palette
        	 fseek(sourcef, pal_offs, 0);
          fread(&cps, sizeof(cps_t), 1, sourcef);
          if ((cps.unknown != 4) || (cps.imsize != 0x300))
          {
            wsprintf (error, "Not a proper COL file!\nSize: %i\nOffset %li\nSize: %li", cps.imsize, pal_offs, pal_length);
            MessageBox(hwnd, error, "COL Plug-in error (open)", MB_OK);
            fclose(sourcef);
            return NULL;  //palette not supported
          }
          mapped->offset = pal_offs;
        }
        else
        {  //normal palette
          mapped->offset = 0;
        }
        mapped->size = size;
        fclose(sourcef);

        strcpy(mapped->name, filename);

        mapped->next = NULL;

        mapped->format = 1000; //plug-in likes this file...
        mapped->palette_type = 1000; // ...and it's a palette

        return mapped;  // we are in business...
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_entry (void)
{
        UnmapViewOfFile(mapped);
        mapped = NULL;
        CloseHandle(hentry);
}
//---------------------------------------------------------------------------
EXPORT void CALLBACK delete_palette_data (void)
{
        UnmapViewOfFile(pPalette);
        pPalette = NULL;
        CloseHandle(hpalette);
}
//---------------------------------------------------------------------------
// returns a short description string of the plug-in
EXPORT char * CALLBACK get_desc (void)
{
        return "Westwood COL Palette";
}
//---------------------------------------------------------------------------
// displaying the "About" -dialog
EXPORT void CALLBACK plugin_info (HWND hwnd)
{
        MessageBox(hwnd, "Plug-in by Compuart", "COL Plug-in", MB_OK);
}
//---------------------------------------------------------------------------
#pragma argsused
unsigned char * decode_80h (int ssiz, int dsiz, unsigned char *dest, HWND hwnd, FILE *fileptr)
{
	unsigned char *source;
   unsigned char b7, b6, b, com, two[2];
   unsigned short posit, count;
	//Source and Dest are the two buffers
   int SP = 0, DP = 0, i;

   source = malloc (ssiz);
   if (source == NULL || dest == NULL)
   {
   	if (source) free(source);
      if (dest) free(dest);
      return NULL;
   }
   fread(source, ssiz, 1, fileptr);

   do {
    com = source[SP];
    SP++;
    if (SP >= ssiz) break;
    b7 = (unsigned char)((com & 0x80) >> 7);  //Com shr 7;  //b7 is bit 7 of Com

    switch (b7)
    {
    	case 0 :  //copy command (2)
      	//Count is bits 4-6 + 3
      	count = (unsigned short) (((com & 0x7F) >> 4) + 3); //(Com and $7F) shr 4 + 3;
         //Position is bits 0-3, with bits 0-7 of next byte
         posit = (unsigned short) (((com & 0x0F) << 8) + source[SP]); //(Com and $0F) shl 8 + Source[SP];
         SP++;
         if (SP >= ssiz) break;
         //Starting pos=Cur pos. - calculated value
         posit = (unsigned short) (DP - posit);
         for(i=posit;i<posit+count;i++) ///for i:=Posit to Posit+Count-1 do
         {
            /*if (DP == 7466) {
               wsprintf(v_viesti, "Hep: %i %li %li", dest[i], i, source[SP]);
               dest[0] = dest[i];
            	MessageBox(hwnd, v_viesti, PNAME, MB_OK);   //error here??????????????????
            }*/
            if (i >= ssiz) break;
            dest[DP] = dest[i];
            DP++;
            if (DP >= dsiz) break;
         }
         break;

      case 1 :  //Check bit 6 of Com
            b6 = (unsigned char)((com & 0x40) >> 6); //(Com and $40) shr 6;

            switch (b6)
            {
            	case 0 : //Copy as is command (1)
               	count = (unsigned short) (com & 0x3F); ///Com and $3F;  //mask 2 topmost bits
                  if (count == 0) break; //EOF marker
                  for (i=1;i<count+1;i++)  //  for i:=1 to Count do
                  {
                  	dest[DP] = source[SP];
                     DP++;
                     SP++;
                     if (SP >= ssiz) break;
                     if (DP >= dsiz) break;
                   }
               break;

              	case 1 : //large copy, very large copy and fill commands    //clear
               	//Count = (bits 0-5 of Com) +3
                  //if Com=FEh then fill, if Com=FFh then very large copy
                  count = (unsigned short) (com & 0x3F); //com and $3F;
                  if (count < 0x3E) //large copy (3)
                  {
                     count = (unsigned short) (count + 3);
                      //Next word = pos. from start of image
                     two[0] = source[SP];
                     two[1] = source[SP+1];
                  	//posit = /*(unsigned short)*/ (source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                     posit = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff))); //SHORT_ORDER(*two);
   						SP = SP + 2;
                     if (SP >= ssiz) break;
                     for (i=posit;i<posit+count;i++) //for i:=Posit to Posit+Count-1 do
                     {
                     	dest[DP] = dest[i];
                        if (i >= dsiz) break;
                        DP++;
                        if (DP >= dsiz) break;
                     }
               	}
                  else if (count == 0x3F)  //very large copy (5)
                  {
                  	//next 2 words are Count and Pos
                     two[0] = source[SP];
                     two[1] = source[SP+1];
                     count = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                  	//count = /*(unsigned short)*/(source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                     two[0] = source[SP+2];
                     two[1] = source[SP+3];
                     //posit = /*(unsigned short)*/(source[SP+2] | (source [SP+3] << 8)); //Word(Source[SP+2]);
                     posit = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                     SP = SP + 4;
                     if (SP >= ssiz) break;
                     for(i=posit;i<posit+count;i++) // for i:=Posit to Posit+Count-1 do
                     {
                        if (i >= dsiz) break;
                     	dest[DP] = dest[i];

                        DP++;
                        if (DP >= dsiz) break;
                     }
                  } else {     //Count=$3E, fill (4)
                      //Next word is count, the byte after is color
                      two[0] = source[SP];
                      two[1] = source[SP+1];
                      count = (unsigned short)(((two[1] & 0xff) << 8) | ((two[0] & 0xff)));
                      //count = /*(unsigned short)*/(source[SP] | (source [SP+1] << 8)); //Word(Source[SP]);
                      SP = SP + 2;
                      if (SP >= ssiz) break;
                      b = source[SP];
                      SP++;
                      if (SP >= ssiz) break;
                      for (i=0;i<count;i++) //for i:=0 to Count-1 do
                      {
                      		dest[DP] = b;

                           DP++;
                           if (DP >= dsiz) break;
                      }
                  }
					}
			}
    }  while (SP < ssiz && DP < dsiz);

    free(source);
    return dest;
}
#pragma argsused
EXPORT char * CALLBACK get_palette_data (HWND hwnd, char *fullname, int size, int offset, int number)
{
   cps_t cps;
   FILE *stream;
   int y;
   
	stream = fopen (fullname, "rb");
   if (stream == NULL)
   {
      return NULL;
   }
   
   if (size == 0) {
   	fseek(stream, 0L, SEEK_END);
      size = ftell(stream);
   }
   fseek(stream, offset, 0);

   hpalette = CreateFileMapping((HANDLE)-1, NULL, PAGE_READWRITE, 0, 768, NULL);
   if (hpalette != NULL)
   {
   	pPalette = (char *) MapViewOfFile(hpalette, FILE_MAP_WRITE, 0, 0, 0);
   }
   else return NULL;

   if (pPalette == NULL)
   	CloseHandle(hpalette);

   else { //this is where the actual reading/uncompressing/converting happens
      if (size == 0x300)
      {
        fread(pPalette, 0x300, 1, stream);
      }
      else
      {
        fread(&cps, sizeof(cps_t), 1, stream);
        if ((cps.unknown != 4) || (cps.imsize != 0x300))
        {
          fclose(stream);
          return NULL;  //palette not supported
        }
        else
        {
          pPalette = decode_80h (0x300, 0x300, pPalette, hwnd, stream);
        }
      }
      for(y=0;y<768;y++)
   	{
      	pPalette[y] = (char) (pPalette[y] * 4);
   	}

   }
   fclose(stream);

   return pPalette;
}
//---------------------------------------------------------------------------
