/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class FunnelGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int topRadius = Integer.parseInt(args[0]);
        int bottomRadius = Integer.parseInt(args[1]);
        int height = Integer.parseInt(args[2]);
        int slices = Integer.parseInt(args[3]);
        int crossSection = Integer.parseInt(args[4]);
        boolean offsetTopInsteadOfBottom = Boolean.valueOf(args[5]);
        boolean extendDownInsteadOfSquare = Boolean.valueOf(args[6]);
        boolean overlappingBrushes = Boolean.valueOf(args[7]);
        boolean generateOnlySeam = Boolean.valueOf(args[8]);
        boolean adjustSeamForJoining = Boolean.valueOf(args[9]);
        double offsetAngle = Double.parseDouble(args[10]);
        Point3D[] topCurve = new Point3D[slices + 1];
        Point3D[] bottomCurve = new Point3D[slices + 1];
        Point3D topPt = new Point3D(topRadius, 0.0, 0.0);
        Point3D bottomPt = new Point3D(bottomRadius, 0.0, -height);
        AxisRotation3D rot = new AxisRotation3D(4, Math.PI / (double)(4 * slices));
        if (!offsetTopInsteadOfBottom) {
            topCurve[0] = topPt;
            bottomCurve[0] = rot.transform(bottomPt);
        } else {
            topCurve[0] = rot.transform(topPt);
            bottomCurve[0] = bottomPt;
        }
        for (int i = 1; i <= slices; ++i) {
            rot = new AxisRotation3D(4, Math.PI * (double)i / (double)(2 * slices));
            topCurve[i] = rot.transform(topCurve[0]);
            bottomCurve[i] = rot.transform(bottomCurve[0]);
        }
        if (adjustSeamForJoining) {
            if (!offsetTopInsteadOfBottom) {
                bottomCurve[slices] = new Point3D(0.0, bottomRadius, -height);
            } else {
                topCurve[slices] = new Point3D(0.0, topRadius, 0.0);
            }
        }
        if (offsetAngle != 0.0 && extendDownInsteadOfSquare) {
            double radians = Math.PI * offsetAngle / 180.0;
            rot = new AxisRotation3D(4, radians);
            for (int i = 0; i <= slices; ++i) {
                topCurve[i] = rot.transform(topCurve[i]);
                bottomCurve[i] = rot.transform(bottomCurve[i]);
            }
        }
        FunnelGenerator.startMap();
        for (int i = 0; i < slices * 2; ++i) {
            Point3D tempBottomPt;
            Point3D tempTopPt;
            if (generateOnlySeam && i != slices * 2 - 1) continue;
            if (i % 2 == 0) {
                if (!offsetTopInsteadOfBottom) {
                    if (topRadius != 0) {
                        FunnelGenerator.writeBrushExtendWrapper(crossSection, topCurve[i / 2], bottomCurve[i / 2], topCurve[i / 2 + 1], i >= slices, extendDownInsteadOfSquare, overlappingBrushes);
                    }
                } else if (bottomRadius != 0) {
                    FunnelGenerator.writeBrushExtendWrapper(crossSection, bottomCurve[i / 2], bottomCurve[i / 2 + 1], topCurve[i / 2], i >= slices, extendDownInsteadOfSquare, overlappingBrushes);
                }
            } else if (!offsetTopInsteadOfBottom) {
                if (bottomRadius != 0) {
                    FunnelGenerator.writeBrushExtendWrapper(crossSection, topCurve[i / 2 + 1], bottomCurve[i / 2], bottomCurve[i / 2 + 1], i >= slices, extendDownInsteadOfSquare, overlappingBrushes);
                }
            } else if (topRadius != 0) {
                FunnelGenerator.writeBrushExtendWrapper(crossSection, topCurve[i / 2], bottomCurve[i / 2 + 1], topCurve[i / 2 + 1], i >= slices, extendDownInsteadOfSquare, overlappingBrushes);
            }
            if (i != slices || extendDownInsteadOfSquare || overlappingBrushes) continue;
            if (i % 2 == 0) {
                tempTopPt = topCurve[i / 2];
                tempBottomPt = bottomCurve[i / 2];
            } else if (!offsetTopInsteadOfBottom) {
                tempTopPt = topCurve[i / 2 + 1];
                tempBottomPt = bottomCurve[i / 2];
            } else {
                tempTopPt = topCurve[i / 2];
                tempBottomPt = bottomCurve[i / 2 + 1];
            }
            FunnelGenerator.writeBrushExtendY(crossSection, tempTopPt, new Point3D(crossSection, tempTopPt.y, tempTopPt.z), new Point3D(crossSection, tempBottomPt.y, tempBottomPt.z), tempBottomPt);
        }
        FunnelGenerator.endMap();
    }

    private static void writeBrushExtendWrapper(int crossSection, Point3D pt1, Point3D pt2, Point3D pt3, boolean pastHalfway, boolean extendDown, boolean overlappingBrushes) {
        if (!extendDown) {
            if (!pastHalfway) {
                FunnelGenerator.writeBrushExtendX(crossSection, pt1, pt2, pt3, overlappingBrushes);
            } else {
                FunnelGenerator.writeBrushExtendY(crossSection, pt1, pt2, pt3, overlappingBrushes);
            }
        } else {
            FunnelGenerator.writeBrushExtendZ(-crossSection, pt1, pt2, pt3, overlappingBrushes);
        }
    }
}

