/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.ExtrudeRadiusFactorCalculator;
import generators.OverlappingVolcanoGenerator;
import generators.VolcanoGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class VolcanoGeneratorGUI
extends JFrame {
    private Config configuration;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String topCircumferenceRadiusTitle = "topCircumferenceRadius";
    private String topCircumferenceRadiusDescription = "The radius of the circumference at the top of the volcano. You probably want to make this value significantly greater than zero.";
    private String slopeRadiusTitle = "slopeRadius";
    private String slopeRadiusDescription = "The radius of the upward slope of the volcano.";
    private String slicesCircumferenceTitle = "slicesCirumference";
    private String slicesCircumferenceDescription = "How many slices to chop the quarter circumference of the volcano into. The total number of triangular surfaces making up this volcano will be 2 * slicesCircumference * slicesSlope.";
    private String slicesSlopeTitle = "slicesSlope";
    private String slicesSlopeDescription = "How many slices to chop the vertical slope of the volcano into. The total number of triangular surfaces making up this volcano will be 2 * slicesCircumference * slicesSlope. ";
    private String crossSectionTitle = "crossSection";
    private String crossSectionDescription = "The distance from the top of the volcano to the bottom of the brushes extending downwards from the volcano.";
    private String offsetTopInsteadOfBottomTitle = "offsetTopInsteadOfBottom";
    private String offsetTopInsteadOfBottomDescription = "Alters the pattern of the mesh by flipping the even-odd rule in which vertices get rotated by half a slice along the circumference. This is useful when joining other offset objects to the circumference of the volcano, such as offset cylinders or funnels. ";
    private String extrudeTopNSlicesTitle = "extrudeTopNSlices";
    private String extrudeTopNSlicesDescription = "f this is greater than zero and if extrudeRadiusFactor is greater than one, the topmost extrudeTopNSlices vertices of the volcano will be pushed back so that the top of the volcano is no longer vertical. It \"relaxes\" the top of the volcano to have a less steep slope. ";
    private String extrudeRadiusFactorTitle = "Extrude Radius Factor";
    private String extrudeRadiusFactorDescription = "Used together with extrudeTopNSlices. This value should be greater than one and extrudeTopNSlices should be greater than zero to make the top of the volcano less steep. It is possible to use values slightly less than one here to generate an \"oversteep\" top, but if used improperly, poor results will be generated, or [possibly] nothing will be generated at all. A value of 1.0 corresponds to a normal volcano with perfectly vertical top. Otherwise, the top vertices are generated based on a radius of slopeRadius * extrudeRadiusFactor.\n\nYou can use the calculator to calculate the extrudeRadiusFactor. ";
    private String adjustForOverlappingPipeCutsTitle = "Adjust For Overlapping Pipe Cuts";
    private String adjustForOverlappingPipeCutsDescription = "n the case where pipe brushes are joined at the seam of this volcano, set this flag whenever the pipe brushes are generated with adjustForOverlappingPipeCuts also.";
    private String adjustForOverlappingBowlCutsTitle = "Adjust For Overlapping Bowl Cuts";
    private String adjustForOverlappingBowlCutsDescription = "Use this when joining other structures that have this flag set.";
    private String invertSlopeVerticesTitle = "Invert Slope Vertices";
    private String invertSlopeVerticesDescription = "The original vertices that make up the slope of the volcano are flipped after all of the adjust and/or extrude flags are applied; the vertex at the rim of the volcano becomes the vertex at the bottom and vice-versa. So, for example, if we are extruding vertices and using this flag together, the bottom of the volcano will no longer be horizontal. ";
    private String generateOnlySeamTitle = "generateOnlySeam";
    private String generateOnlySeamDescription = "Generates only the seam brushes.";
    private String adjustSeamForJoiningTitle = "adjustSeamForJoining";
    private String adjustSeamForJoiningDescription = "Perturb the vertices of the seam brushes so that other structures such as pipes can be joined perfectly to this quarter volcano.";
    private String cutTopTitle = "cutTop";
    private String cutTopDescription = "Automatically cuts the volcano at the top to make a flat top. The brushes at the top are constructed so that they don't extend beyond the top. You can only be sure that no brushes extend beyond the top if adjustForOverlappingPipeCuts is true. (I also think that if you set invertSlopeVertices, you cannot guarantee that no brush will extend beyond the top.)";
    private String cutBottomTitle = "cutBottom";
    private String cutBottomDescription = "The brushes at the bottom are cut. I believe that chances are pretty good that some 2nd-level brushes will happen to extend just a tad beyond.";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a bowl wall to fling you around at high speeds, you will have to generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nonsolid.";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making bowls such that the player doesn't \"bounce\" off the surface when flying along the bowl. However, it is not advised to texture the overlapping brush faces with drawn textures. Instead, apply [slick] caulk to all of the overlapping brushes, then superimpose a set of normal non-overlapping brushes that have surfaceparm nonsolid. NOTE: When you are done generating overlapping brushes, you will likely want to cut everything off that is above z = 0. Use adjustForOverlappingBowlCuts to ensure that the resulting cuts are clean and along integer coordinates. ";
    private JCheckBox adjustForOverlappingBowlCuts;
    private JPanel adjustForOverlappingBowlCutsPanel;
    private JCheckBox adjustForOverlappingPipeCuts;
    private JPanel adjustForOverlappingPipeCutsPanel;
    private JCheckBox adjustSeamForJoining;
    private JPanel adjustSeamForJoiningPanel;
    private JButton calculate;
    private JMenuItem calculateExtrudeRadiusFactor;
    private JDialog calculateExtrudeRadiusPopup;
    private JPanel calculatePanel;
    private JMenu calculator;
    private JTextArea calculatorDescription;
    private JPanel calculatorDescriptionPanel;
    private JPanel calculatorOptionPanel;
    private JPanel calculatorPanel;
    private JLabel calculatorStatus;
    private JPanel calculatorStatusPanel;
    private JPanel crossSectionPanel;
    private JCheckBox cutBottom;
    private JPanel cutBottomPanel;
    private JCheckBox cutTop;
    private JPanel cutTopPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JPanel extrudeRadiusFactorPanel;
    private JPanel extrudeTopNSlicesPanel;
    private JButton generate;
    private JCheckBox generateOnlySeam;
    private JPanel generateOnlySeamPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inCrossSection;
    private JTextField inExtrudeRadiusFactor;
    private JTextField inExtrudeTopNSlices;
    private JTextField inLipOffset;
    private JTextField inSlicesCirumference;
    private JTextField inSlicesSlope;
    private JTextField inSlopeRadius;
    private JTextField inTopCircumferenceRadius;
    private JCheckBox invertSlopeVertices;
    private JPanel invertSlopeVerticesPanel;
    private JLabel laLipOffset;
    private JLabel labCrossSection;
    private JLabel labExtrudeRadiusFactor;
    private JLabel labExtrudeTopNSlices;
    private JLabel labSlicesCircumference;
    private JLabel labSlicesSlope;
    private JLabel labSlopeRadius;
    private JLabel labTopCircumferenceRadius;
    private JMenuBar menuBar;
    private JPanel normalOptionPanel;
    private JCheckBox offsetTopInsteadOfBottom;
    private JPanel offsetTopInsteadOfBottomPanel;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel overlappingBrushOptionPanel;
    private JScrollPane scrollPane;
    private JPanel slicesCircumferencePanel;
    private JPanel slicesSlopePanel;
    private JPanel slopeRadiusPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel topCircumferenceRadiusPanel;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public VolcanoGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.calculateExtrudeRadiusPopup = new JDialog();
        this.calculatorPanel = new JPanel();
        this.calculatorOptionPanel = new JPanel();
        this.laLipOffset = new JLabel();
        this.inLipOffset = new JTextField();
        this.calculatorStatusPanel = new JPanel();
        this.calculatorStatus = new JLabel();
        this.calculatePanel = new JPanel();
        this.calculate = new JButton();
        this.calculatorDescriptionPanel = new JPanel();
        this.calculatorDescription = new JTextArea();
        this.scrollPane = new JScrollPane();
        this.viewPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.valuesPanel = new JPanel();
        this.topCircumferenceRadiusPanel = new JPanel();
        this.labTopCircumferenceRadius = new JLabel();
        this.inTopCircumferenceRadius = new JTextField();
        this.crossSectionPanel = new JPanel();
        this.labCrossSection = new JLabel();
        this.inCrossSection = new JTextField();
        this.slicesCircumferencePanel = new JPanel();
        this.labSlicesCircumference = new JLabel();
        this.inSlicesCirumference = new JTextField();
        this.slicesSlopePanel = new JPanel();
        this.labSlicesSlope = new JLabel();
        this.inSlicesSlope = new JTextField();
        this.extrudeRadiusFactorPanel = new JPanel();
        this.labExtrudeRadiusFactor = new JLabel();
        this.inExtrudeRadiusFactor = new JTextField();
        this.adjustForOverlappingBowlCutsPanel = new JPanel();
        this.adjustForOverlappingBowlCuts = new JCheckBox();
        this.extrudeTopNSlicesPanel = new JPanel();
        this.labExtrudeTopNSlices = new JLabel();
        this.inExtrudeTopNSlices = new JTextField();
        this.adjustForOverlappingPipeCutsPanel = new JPanel();
        this.adjustForOverlappingPipeCuts = new JCheckBox();
        this.slopeRadiusPanel = new JPanel();
        this.labSlopeRadius = new JLabel();
        this.inSlopeRadius = new JTextField();
        this.offsetTopInsteadOfBottomPanel = new JPanel();
        this.offsetTopInsteadOfBottom = new JCheckBox();
        this.adjustSeamForJoiningPanel = new JPanel();
        this.adjustSeamForJoining = new JCheckBox();
        this.generateOnlySeamPanel = new JPanel();
        this.generateOnlySeam = new JCheckBox();
        this.invertSlopeVerticesPanel = new JPanel();
        this.invertSlopeVertices = new JCheckBox();
        this.cutTopPanel = new JPanel();
        this.cutTop = new JCheckBox();
        this.cutBottomPanel = new JPanel();
        this.cutBottom = new JCheckBox();
        this.menuBar = new JMenuBar();
        this.calculator = new JMenu();
        this.calculateExtrudeRadiusFactor = new JMenuItem();
        this.calculateExtrudeRadiusPopup.setTitle("Extrude Radius Factor Calculator");
        this.calculateExtrudeRadiusPopup.setMinimumSize(new Dimension(330, 372));
        this.laLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.laLipOffset.setText("lipOffset:");
        this.inLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.inLipOffset.setText("5");
        this.inLipOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inLipOffsetActionPerformed(evt);
            }
        });
        this.inLipOffset.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inLipOffsetFocusLost(evt);
            }
        });
        this.inLipOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                VolcanoGeneratorGUI.this.inLipOffsetPropertyChange(evt);
            }
        });
        this.inLipOffset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                VolcanoGeneratorGUI.this.inLipOffsetKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                VolcanoGeneratorGUI.this.inLipOffsetKeyPressed(evt);
            }
        });
        GroupLayout calculatorOptionPanelLayout = new GroupLayout(this.calculatorOptionPanel);
        this.calculatorOptionPanel.setLayout(calculatorOptionPanelLayout);
        calculatorOptionPanelLayout.setHorizontalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorOptionPanelLayout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).addComponent(this.laLipOffset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inLipOffset, -2, 48, -2).addContainerGap()));
        calculatorOptionPanelLayout.setVerticalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorOptionPanelLayout.createSequentialGroup().addGap(0, 25, Short.MAX_VALUE).addGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inLipOffset, -2, -1, -2).addComponent(this.laLipOffset))));
        this.calculatorStatus.setFont(new Font("Tahoma", 0, 12));
        this.calculatorStatus.setText("Enter a value for the lip offset");
        GroupLayout calculatorStatusPanelLayout = new GroupLayout(this.calculatorStatusPanel);
        this.calculatorStatusPanel.setLayout(calculatorStatusPanelLayout);
        calculatorStatusPanelLayout.setHorizontalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorStatusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorStatus, -1, 220, Short.MAX_VALUE).addContainerGap()));
        calculatorStatusPanelLayout.setVerticalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorStatusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorStatus).addContainerGap()));
        this.calculate.setText("Calculate");
        this.calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.calculateActionPerformed(evt);
            }
        });
        GroupLayout calculatePanelLayout = new GroupLayout(this.calculatePanel);
        this.calculatePanel.setLayout(calculatePanelLayout);
        calculatePanelLayout.setHorizontalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculate, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculatePanelLayout.setVerticalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addGap(0, 24, Short.MAX_VALUE).addComponent(this.calculate)));
        this.calculatorDescription.setEditable(false);
        this.calculatorDescription.setBackground(new Color(240, 240, 240));
        this.calculatorDescription.setColumns(20);
        this.calculatorDescription.setLineWrap(true);
        this.calculatorDescription.setRows(5);
        this.calculatorDescription.setText("Calculates the extrudeRadiusFactor based on the values of slopeRadius, slicesSlope and topNSlices.\n\nThe lipOffset is the number of units the top edge of the circular arc is to be nudged outward.\n\nNote that specifying a lipOffset of greater than what is possible to extrude (by setting a radius to be very large)  will generate erroneous results. ");
        this.calculatorDescription.setWrapStyleWord(true);
        GroupLayout calculatorDescriptionPanelLayout = new GroupLayout(this.calculatorDescriptionPanel);
        this.calculatorDescriptionPanel.setLayout(calculatorDescriptionPanelLayout);
        calculatorDescriptionPanelLayout.setHorizontalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescription, -2, 292, -2).addContainerGap(-1, Short.MAX_VALUE)));
        calculatorDescriptionPanelLayout.setVerticalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorDescription, -2, 198, -2).addGap(245, 245, 245)));
        GroupLayout calculatorPanelLayout = new GroupLayout(this.calculatorPanel);
        this.calculatorPanel.setLayout(calculatorPanelLayout);
        calculatorPanelLayout.setHorizontalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.calculatorStatusPanel, -2, -1, -2).addGroup(calculatorPanelLayout.createSequentialGroup().addComponent(this.calculatorOptionPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.calculatePanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.calculatorDescriptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        calculatorPanelLayout.setVerticalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescriptionPanel, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calculatorOptionPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.calculatePanel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.calculatorStatusPanel, -2, -1, -2).addContainerGap()));
        GroupLayout calculateExtrudeRadiusPopupLayout = new GroupLayout(this.calculateExtrudeRadiusPopup.getContentPane());
        this.calculateExtrudeRadiusPopup.getContentPane().setLayout(calculateExtrudeRadiusPopupLayout);
        calculateExtrudeRadiusPopupLayout.setHorizontalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculateExtrudeRadiusPopupLayout.setVerticalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setTitle("Volcano Generator");
        this.setLocationByPlatform(true);
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -2, 297, -2).addGap(26, 26, 26)));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/volcano.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates a quarter of a volcano shape, which is actually the inner rim of the inside of a donut.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, 683, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generate).addGap(18, 18, 18)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.generate)).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 45, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.topCircumferenceRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.topCircumferenceRadiusPanelFocusGained(evt);
            }
        });
        this.labTopCircumferenceRadius.setLabelFor(this.inTopCircumferenceRadius);
        this.labTopCircumferenceRadius.setText("topCircumferenceRadius:");
        this.inTopCircumferenceRadius.setText("384");
        this.inTopCircumferenceRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inTopCircumferenceRadiusActionPerformed(evt);
            }
        });
        this.inTopCircumferenceRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inTopCircumferenceRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inTopCircumferenceRadiusFocusLost(evt);
            }
        });
        GroupLayout topCircumferenceRadiusPanelLayout = new GroupLayout(this.topCircumferenceRadiusPanel);
        this.topCircumferenceRadiusPanel.setLayout(topCircumferenceRadiusPanelLayout);
        topCircumferenceRadiusPanelLayout.setHorizontalGroup(topCircumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(topCircumferenceRadiusPanelLayout.createSequentialGroup().addContainerGap(70, Short.MAX_VALUE).addComponent(this.labTopCircumferenceRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inTopCircumferenceRadius, -2, 64, -2).addContainerGap()));
        topCircumferenceRadiusPanelLayout.setVerticalGroup(topCircumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, topCircumferenceRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(topCircumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labTopCircumferenceRadius).addComponent(this.inTopCircumferenceRadius, -2, -1, -2)).addContainerGap()));
        this.labCrossSection.setLabelFor(this.inCrossSection);
        this.labCrossSection.setText("crossSection:");
        this.inCrossSection.setText("640");
        this.inCrossSection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inCrossSectionActionPerformed(evt);
            }
        });
        this.inCrossSection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inCrossSectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inCrossSectionFocusLost(evt);
            }
        });
        GroupLayout crossSectionPanelLayout = new GroupLayout(this.crossSectionPanel);
        this.crossSectionPanel.setLayout(crossSectionPanelLayout);
        crossSectionPanelLayout.setHorizontalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCrossSection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCrossSection, -2, 64, -2).addContainerGap()));
        crossSectionPanelLayout.setVerticalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCrossSection).addComponent(this.inCrossSection, -2, -1, -2)).addContainerGap()));
        this.labSlicesCircumference.setLabelFor(this.inSlicesCirumference);
        this.labSlicesCircumference.setText("slicesCircumference:");
        this.inSlicesCirumference.setText("14");
        this.inSlicesCirumference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesCirumferenceActionPerformed(evt);
            }
        });
        this.inSlicesCirumference.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesCirumferenceFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesCirumferenceFocusLost(evt);
            }
        });
        GroupLayout slicesCircumferencePanelLayout = new GroupLayout(this.slicesCircumferencePanel);
        this.slicesCircumferencePanel.setLayout(slicesCircumferencePanelLayout);
        slicesCircumferencePanelLayout.setHorizontalGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesCircumferencePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesCircumference).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesCirumference, -2, 64, -2).addContainerGap()));
        slicesCircumferencePanelLayout.setVerticalGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesCircumferencePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesCircumference).addComponent(this.inSlicesCirumference, -2, -1, -2)).addContainerGap()));
        this.labSlicesSlope.setLabelFor(this.inSlicesSlope);
        this.labSlicesSlope.setText("slicesSlope:");
        this.inSlicesSlope.setText("14");
        this.inSlicesSlope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesSlopeActionPerformed(evt);
            }
        });
        this.inSlicesSlope.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesSlopeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlicesSlopeFocusLost(evt);
            }
        });
        GroupLayout slicesSlopePanelLayout = new GroupLayout(this.slicesSlopePanel);
        this.slicesSlopePanel.setLayout(slicesSlopePanelLayout);
        slicesSlopePanelLayout.setHorizontalGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesSlopePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesSlope).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesSlope, -2, 64, -2).addContainerGap()));
        slicesSlopePanelLayout.setVerticalGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesSlopePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesSlope).addComponent(this.inSlicesSlope, -2, -1, -2))));
        this.labExtrudeRadiusFactor.setLabelFor(this.inExtrudeRadiusFactor);
        this.labExtrudeRadiusFactor.setText("extrudeRadiusFactor:");
        this.labExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.setText("1.0");
        this.inExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeRadiusFactorActionPerformed(evt);
            }
        });
        this.inExtrudeRadiusFactor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeRadiusFactorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeRadiusFactorFocusLost(evt);
            }
        });
        GroupLayout extrudeRadiusFactorPanelLayout = new GroupLayout(this.extrudeRadiusFactorPanel);
        this.extrudeRadiusFactorPanel.setLayout(extrudeRadiusFactorPanelLayout);
        extrudeRadiusFactorPanelLayout.setHorizontalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeRadiusFactorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labExtrudeRadiusFactor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.inExtrudeRadiusFactor, -2, 165, -2).addContainerGap()));
        extrudeRadiusFactorPanelLayout.setVerticalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeRadiusFactorPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeRadiusFactor).addComponent(this.inExtrudeRadiusFactor, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingBowlCuts.setText("adjustForOverlappingBowlCuts");
        this.adjustForOverlappingBowlCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingBowlCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingBowlCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustForOverlappingBowlCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustForOverlappingBowlCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingBowlCutsPanelLayout = new GroupLayout(this.adjustForOverlappingBowlCutsPanel);
        this.adjustForOverlappingBowlCutsPanel.setLayout(adjustForOverlappingBowlCutsPanelLayout);
        adjustForOverlappingBowlCutsPanelLayout.setHorizontalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustForOverlappingBowlCuts, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustForOverlappingBowlCutsPanelLayout.setVerticalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCuts, -2, 23, -2)));
        this.labExtrudeTopNSlices.setText("extrudeTopNSlices:");
        this.inExtrudeTopNSlices.setText("0");
        this.inExtrudeTopNSlices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeTopNSlicesActionPerformed(evt);
            }
        });
        this.inExtrudeTopNSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeTopNSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inExtrudeTopNSlicesFocusLost(evt);
            }
        });
        GroupLayout extrudeTopNSlicesPanelLayout = new GroupLayout(this.extrudeTopNSlicesPanel);
        this.extrudeTopNSlicesPanel.setLayout(extrudeTopNSlicesPanelLayout);
        extrudeTopNSlicesPanelLayout.setHorizontalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labExtrudeTopNSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inExtrudeTopNSlices, -2, 64, -2).addContainerGap()));
        extrudeTopNSlicesPanelLayout.setVerticalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeTopNSlices).addComponent(this.inExtrudeTopNSlices, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingPipeCuts.setText("adjustForOverlappingPipeCuts");
        this.adjustForOverlappingPipeCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingPipeCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingPipeCuts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.adjustForOverlappingPipeCutsActionPerformed(evt);
            }
        });
        this.adjustForOverlappingPipeCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustForOverlappingPipeCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustForOverlappingPipeCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingPipeCutsPanelLayout = new GroupLayout(this.adjustForOverlappingPipeCutsPanel);
        this.adjustForOverlappingPipeCutsPanel.setLayout(adjustForOverlappingPipeCutsPanelLayout);
        adjustForOverlappingPipeCutsPanelLayout.setHorizontalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts).addContainerGap()));
        adjustForOverlappingPipeCutsPanelLayout.setVerticalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts, -2, 23, -2)));
        this.slopeRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.slopeRadiusPanelFocusGained(evt);
            }
        });
        this.labSlopeRadius.setLabelFor(this.inTopCircumferenceRadius);
        this.labSlopeRadius.setText("slopeRadius:");
        this.inSlopeRadius.setText("512");
        this.inSlopeRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.inSlopeRadiusActionPerformed(evt);
            }
        });
        this.inSlopeRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlopeRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.inSlopeRadiusFocusLost(evt);
            }
        });
        GroupLayout slopeRadiusPanelLayout = new GroupLayout(this.slopeRadiusPanel);
        this.slopeRadiusPanel.setLayout(slopeRadiusPanelLayout);
        slopeRadiusPanelLayout.setHorizontalGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slopeRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlopeRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlopeRadius, -2, 64, -2).addContainerGap()));
        slopeRadiusPanelLayout.setVerticalGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slopeRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlopeRadius).addComponent(this.inSlopeRadius, -2, -1, -2)).addContainerGap()));
        this.offsetTopInsteadOfBottom.setText("offsetTopInsteadOfBottom");
        this.offsetTopInsteadOfBottom.setHorizontalAlignment(11);
        this.offsetTopInsteadOfBottom.setHorizontalTextPosition(10);
        this.offsetTopInsteadOfBottom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.offsetTopInsteadOfBottomFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.offsetTopInsteadOfBottomFocusLost(evt);
            }
        });
        GroupLayout offsetTopInsteadOfBottomPanelLayout = new GroupLayout(this.offsetTopInsteadOfBottomPanel);
        this.offsetTopInsteadOfBottomPanel.setLayout(offsetTopInsteadOfBottomPanelLayout);
        offsetTopInsteadOfBottomPanelLayout.setHorizontalGroup(offsetTopInsteadOfBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetTopInsteadOfBottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.offsetTopInsteadOfBottom, -1, -1, Short.MAX_VALUE).addContainerGap()));
        offsetTopInsteadOfBottomPanelLayout.setVerticalGroup(offsetTopInsteadOfBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetTopInsteadOfBottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.offsetTopInsteadOfBottom).addContainerGap(-1, Short.MAX_VALUE)));
        this.adjustSeamForJoining.setText("adjustSeamForJoining");
        this.adjustSeamForJoining.setHorizontalAlignment(11);
        this.adjustSeamForJoining.setHorizontalTextPosition(10);
        this.adjustSeamForJoining.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustSeamForJoiningFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.adjustSeamForJoiningFocusLost(evt);
            }
        });
        GroupLayout adjustSeamForJoiningPanelLayout = new GroupLayout(this.adjustSeamForJoiningPanel);
        this.adjustSeamForJoiningPanel.setLayout(adjustSeamForJoiningPanelLayout);
        adjustSeamForJoiningPanelLayout.setHorizontalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustSeamForJoiningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustSeamForJoining, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustSeamForJoiningPanelLayout.setVerticalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining, -2, 23, -2)));
        this.generateOnlySeam.setText("generateOnlySeam");
        this.generateOnlySeam.setHorizontalAlignment(11);
        this.generateOnlySeam.setHorizontalTextPosition(10);
        this.generateOnlySeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.generateOnlySeamActionPerformed(evt);
            }
        });
        this.generateOnlySeam.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.generateOnlySeamFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.generateOnlySeamFocusLost(evt);
            }
        });
        GroupLayout generateOnlySeamPanelLayout = new GroupLayout(this.generateOnlySeamPanel);
        this.generateOnlySeamPanel.setLayout(generateOnlySeamPanelLayout);
        generateOnlySeamPanelLayout.setHorizontalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateOnlySeam, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateOnlySeamPanelLayout.setVerticalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.generateOnlySeam, -2, 23, -2)));
        this.invertSlopeVertices.setText("invertSlopeVertices");
        this.invertSlopeVertices.setHorizontalAlignment(11);
        this.invertSlopeVertices.setHorizontalTextPosition(10);
        this.invertSlopeVertices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.invertSlopeVerticesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.invertSlopeVerticesFocusLost(evt);
            }
        });
        GroupLayout invertSlopeVerticesPanelLayout = new GroupLayout(this.invertSlopeVerticesPanel);
        this.invertSlopeVerticesPanel.setLayout(invertSlopeVerticesPanelLayout);
        invertSlopeVerticesPanelLayout.setHorizontalGroup(invertSlopeVerticesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(invertSlopeVerticesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.invertSlopeVertices, -1, -1, Short.MAX_VALUE).addContainerGap()));
        invertSlopeVerticesPanelLayout.setVerticalGroup(invertSlopeVerticesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, invertSlopeVerticesPanelLayout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.invertSlopeVertices, -2, 23, -2)));
        this.cutTop.setText("cutTop");
        this.cutTop.setEnabled(false);
        this.cutTop.setHorizontalAlignment(11);
        this.cutTop.setHorizontalTextPosition(10);
        this.cutTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.cutTopActionPerformed(evt);
            }
        });
        this.cutTop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.cutTopFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.cutTopFocusLost(evt);
            }
        });
        GroupLayout cutTopPanelLayout = new GroupLayout(this.cutTopPanel);
        this.cutTopPanel.setLayout(cutTopPanelLayout);
        cutTopPanelLayout.setHorizontalGroup(cutTopPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, cutTopPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cutTop, -1, -1, Short.MAX_VALUE).addContainerGap()));
        cutTopPanelLayout.setVerticalGroup(cutTopPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, cutTopPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.cutTop, -2, 23, -2)));
        this.cutBottom.setText("cutBottom");
        this.cutBottom.setEnabled(false);
        this.cutBottom.setHorizontalAlignment(11);
        this.cutBottom.setHorizontalTextPosition(10);
        this.cutBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.cutBottomActionPerformed(evt);
            }
        });
        this.cutBottom.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                VolcanoGeneratorGUI.this.cutBottomFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                VolcanoGeneratorGUI.this.cutBottomFocusLost(evt);
            }
        });
        GroupLayout cutBottomPanelLayout = new GroupLayout(this.cutBottomPanel);
        this.cutBottomPanel.setLayout(cutBottomPanelLayout);
        cutBottomPanelLayout.setHorizontalGroup(cutBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, cutBottomPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cutBottom, -1, -1, Short.MAX_VALUE).addContainerGap()));
        cutBottomPanelLayout.setVerticalGroup(cutBottomPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, cutBottomPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.cutBottom, -2, 23, -2)));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offsetTopInsteadOfBottomPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.extrudeTopNSlicesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.crossSectionPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesSlopePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesCircumferencePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slopeRadiusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.topCircumferenceRadiusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.adjustSeamForJoiningPanel, -1, -1, Short.MAX_VALUE).addComponent(this.generateOnlySeamPanel, -1, -1, Short.MAX_VALUE))).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cutTopPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.cutBottomPanel, -1, -1, Short.MAX_VALUE))).addGroup(valuesPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.invertSlopeVerticesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.extrudeRadiusFactorPanel, -1, 342, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCutsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCutsPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.topCircumferenceRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slopeRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesCircumferencePanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesSlopePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossSectionPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetTopInsteadOfBottomPanel, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeTopNSlicesPanel, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeRadiusFactorPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingPipeCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingBowlCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.invertSlopeVerticesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateOnlySeamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustSeamForJoiningPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutTopPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutBottomPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(viewPanelLayout.createSequentialGroup().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuesPanel, -2, -1, -2).addComponent(this.optionsPanel, -2, -1, -2)).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.iconPanel, -2, -1, -2).addGap(44, 44, 44)).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPanel, -2, 323, -2)))).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.subtitlePanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addGap(18, 18, 18).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.descriptionPanel, -2, -1, -2).addGap(38, 38, 38).addComponent(this.iconPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.optionsPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.scrollPane.setViewportView(this.viewPanel);
        this.calculator.setText("Calculator");
        this.calculator.setToolTipText("Calculates the extrudeRadiusFactor for a given lip offset");
        this.calculateExtrudeRadiusFactor.setText("Calculate extrudeRadiusFactor");
        this.calculateExtrudeRadiusFactor.setToolTipText("extrudeTopNSlices must be positive to use the calculator");
        this.calculateExtrudeRadiusFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VolcanoGeneratorGUI.this.calculateExtrudeRadiusFactorActionPerformed(evt);
            }
        });
        this.calculator.add(this.calculateExtrudeRadiusFactor);
        this.menuBar.add(this.calculator);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPane).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void inTopCircumferenceRadiusFocusGained(FocusEvent evt) {
        this.topCircumferenceRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.topCircumferenceRadiusTitle);
        this.description.setText(this.topCircumferenceRadiusDescription);
    }

    private void inTopCircumferenceRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void topCircumferenceRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inCrossSectionFocusGained(FocusEvent evt) {
        this.crossSectionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.crossSectionTitle);
        this.description.setText(this.crossSectionDescription);
    }

    private void inCrossSectionFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesCirumferenceFocusGained(FocusEvent evt) {
        this.slicesCircumferencePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesCircumferenceTitle);
        this.description.setText(this.slicesCircumferenceDescription);
    }

    private void inSlicesCirumferenceFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingPipeCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingPipeCutsTitle);
        this.description.setText(this.adjustForOverlappingPipeCutsDescription);
    }

    private void adjustForOverlappingPipeCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.normal);
    }

    private void inExtrudeRadiusFactorFocusGained(FocusEvent evt) {
        this.extrudeRadiusFactorPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeRadiusFactorTitle);
        this.description.setText(this.extrudeRadiusFactorDescription);
    }

    private void inExtrudeRadiusFactorFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        String[] args;
        this.generate.setEnabled(false);
        if (this.opNormal.isSelected()) {
            args = new String[]{this.inTopCircumferenceRadius.getText(), this.inSlopeRadius.getText(), this.inSlicesCirumference.getText(), this.inSlicesSlope.getText(), this.inCrossSection.getText(), Boolean.toString(this.offsetTopInsteadOfBottom.isSelected()), this.inExtrudeTopNSlices.getText(), this.inExtrudeRadiusFactor.getText(), Boolean.toString(this.adjustForOverlappingPipeCuts.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected()), Boolean.toString(this.invertSlopeVertices.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected())};
            this.status.setText("Generating volcano...");
            VolcanoGenerator.main(args);
        }
        if (this.opOverlapping.isSelected()) {
            args = new String[]{this.inTopCircumferenceRadius.getText(), this.inSlopeRadius.getText(), this.inSlicesCirumference.getText(), this.inSlicesSlope.getText(), this.inCrossSection.getText(), Boolean.toString(this.offsetTopInsteadOfBottom.isSelected()), this.inExtrudeTopNSlices.getText(), this.inExtrudeRadiusFactor.getText(), Boolean.toString(this.adjustForOverlappingPipeCuts.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected()), Boolean.toString(this.invertSlopeVertices.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected()), Boolean.toString(this.cutTop.isSelected()), Boolean.toString(this.cutBottom.isSelected())};
            this.status.setText("Generating overlapping volcano...");
            OverlappingVolcanoGenerator.main(args);
        }
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void adjustForOverlappingPipeCutsActionPerformed(ActionEvent evt) {
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inExtrudeTopNSlicesFocusGained(FocusEvent evt) {
        this.extrudeTopNSlicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeTopNSlicesTitle);
        this.description.setText(this.extrudeTopNSlicesDescription);
    }

    private void inExtrudeTopNSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingBowlCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingBowlCutsTitle);
        this.description.setText(this.adjustForOverlappingBowlCutsDescription);
    }

    private void adjustForOverlappingBowlCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.normal);
    }

    private void inSlopeRadiusFocusGained(FocusEvent evt) {
        this.slopeRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slopeRadiusTitle);
        this.description.setText(this.slopeRadiusDescription);
    }

    private void inSlopeRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void slopeRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void adjustSeamForJoiningFocusGained(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustSeamForJoiningTitle);
        this.description.setText(this.adjustSeamForJoiningDescription);
    }

    private void adjustSeamForJoiningFocusLost(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.normal);
    }

    private void generateOnlySeamFocusGained(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.generateOnlySeamTitle);
        this.description.setText(this.generateOnlySeamDescription);
    }

    private void generateOnlySeamFocusLost(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.normal);
    }

    private void inSlicesSlopeFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesSlopeFocusGained(FocusEvent evt) {
        this.slicesSlopePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesSlopeTitle);
        this.description.setText(this.slicesSlopeDescription);
    }

    private void generateOnlySeamActionPerformed(ActionEvent evt) {
    }

    private void offsetTopInsteadOfBottomFocusGained(FocusEvent evt) {
        this.offsetTopInsteadOfBottomPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetTopInsteadOfBottomTitle);
        this.description.setText(this.offsetTopInsteadOfBottomDescription);
    }

    private void offsetTopInsteadOfBottomFocusLost(FocusEvent evt) {
        this.offsetTopInsteadOfBottomPanel.setBackground(this.normal);
    }

    private void inLipOffsetFocusLost(FocusEvent evt) {
        this.status.setText("");
        try {
            int temp = Integer.parseInt(this.inLipOffset.getText());
            if (temp < 0) {
                throw new Exception("lipOffset cannot be negative");
            }
            this.calculatorOptionPanel.setBackground(this.normal);
            this.calculatorStatusPanel.setBackground(this.normal);
            this.calculate.setEnabled(true);
        }
        catch (Exception ex) {
            this.calculate.setEnabled(false);
            if (ex instanceof NumberFormatException) {
                this.calculatorStatus.setText("Please enter a number");
            } else {
                this.calculatorStatus.setText(ex.getMessage());
            }
            this.calculatorOptionPanel.setBackground(Color.red);
            this.calculatorStatusPanel.setBackground(Color.yellow);
        }
    }

    private void inLipOffsetPropertyChange(PropertyChangeEvent evt) {
    }

    private void inLipOffsetKeyPressed(KeyEvent evt) {
    }

    private void inLipOffsetKeyTyped(KeyEvent evt) {
    }

    private void calculateActionPerformed(ActionEvent evt) {
        String[] args = new String[]{this.inSlopeRadius.getText(), this.inSlicesSlope.getText(), this.inExtrudeTopNSlices.getText(), this.inLipOffset.getText()};
        this.inExtrudeRadiusFactor.setText(Double.toString(ExtrudeRadiusFactorCalculator.calculate(args)));
        this.calculateExtrudeRadiusPopup.setVisible(false);
    }

    private void calculateExtrudeRadiusFactorActionPerformed(ActionEvent evt) {
        this.calculateExtrudeRadiusPopup.setVisible(true);
    }

    private void inExtrudeRadiusFactorActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inTopCircumferenceRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlopeRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesCirumferenceActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesSlopeActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCrossSectionActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inExtrudeTopNSlicesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLipOffsetActionPerformed(ActionEvent evt) {
        this.status.setText("");
        try {
            int temp = Integer.parseInt(this.inLipOffset.getText());
            if (temp < 0) {
                throw new Exception("lipOffset cannot be negative");
            }
            this.calculatorOptionPanel.setBackground(this.normal);
            this.calculatorStatusPanel.setBackground(this.normal);
            this.calculate.setEnabled(true);
        }
        catch (Exception ex) {
            this.calculate.setEnabled(false);
            if (ex instanceof NumberFormatException) {
                this.calculatorStatus.setText("Please enter a number");
            } else {
                this.calculatorStatus.setText(ex.getMessage());
            }
            this.calculatorOptionPanel.setBackground(Color.red);
            this.calculatorStatusPanel.setBackground(Color.yellow);
        }
    }

    private void invertSlopeVerticesFocusGained(FocusEvent evt) {
        this.invertSlopeVerticesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.invertSlopeVerticesTitle);
        this.description.setText(this.invertSlopeVerticesDescription);
    }

    private void invertSlopeVerticesFocusLost(FocusEvent evt) {
        this.invertSlopeVerticesPanel.setBackground(this.normal);
    }

    private void cutTopActionPerformed(ActionEvent evt) {
    }

    private void cutTopFocusGained(FocusEvent evt) {
        this.cutTopPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.cutTopTitle);
        this.description.setText(this.cutTopDescription);
    }

    private void cutTopFocusLost(FocusEvent evt) {
        this.cutTopPanel.setBackground(this.shaded);
    }

    private void cutBottomActionPerformed(ActionEvent evt) {
    }

    private void cutBottomFocusGained(FocusEvent evt) {
        this.cutBottomPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.cutBottomTitle);
        this.description.setText(this.cutBottomDescription);
    }

    private void cutBottomFocusLost(FocusEvent evt) {
        this.cutBottomPanel.setBackground(this.shaded);
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        boolean calculateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inTopCircumferenceRadius.getText());
            if (temp <= 0) {
                throw new Exception("topCircumferenceRadius must be positive");
            }
            this.topCircumferenceRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for\n" : statusText + ex.getMessage() + "\n";
            this.topCircumferenceRadiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlopeRadius.getText());
            if (temp < 0) {
                throw new Exception("slopeRadius cannot be negative");
            }
            this.slopeRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for slopeRadius\n" : statusText + ex.getMessage() + "\n";
            this.slopeRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inSlicesCirumference.getText());
            if (temp2 < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesCircumferencePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for slicesCircumference\n" : statusText + ex.getMessage() + "\n";
            this.slicesCircumferencePanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inSlicesSlope.getText());
            if (temp3 < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesSlopePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for slicesSlope\n" : statusText + ex.getMessage() + "\n";
            this.slicesSlopePanel.setBackground(Color.red);
        }
        try {
            int temp4 = Integer.parseInt(this.inExtrudeTopNSlices.getText());
            if (temp4 <= 0) {
                calculateOK = false;
                this.labExtrudeRadiusFactor.setEnabled(false);
                this.inExtrudeRadiusFactor.setEnabled(false);
            } else {
                this.labExtrudeRadiusFactor.setEnabled(true);
                this.inExtrudeRadiusFactor.setEnabled(true);
            }
            if (temp4 < 0) {
                throw new Exception("extrudeTopNSlices cannot be negative");
            }
            this.extrudeTopNSlicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for extrudeTopNSlices\n" : statusText + ex.getMessage() + "\n";
            this.extrudeTopNSlicesPanel.setBackground(Color.red);
        }
        try {
            double temp5 = Double.parseDouble(this.inExtrudeRadiusFactor.getText());
            if (temp5 < 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.extrudeRadiusFactorPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex.getMessage().startsWith("For input String:") ? statusText + "Please enter a number for inExtrudeRadiusFactor\n" : statusText + ex.getMessage() + "\n";
            this.extrudeRadiusFactorPanel.setBackground(Color.red);
        }
        try {
            int temp6 = Integer.parseInt(this.inCrossSection.getText());
            if (temp6 <= 0) {
                throw new Exception("inCrossSection cannot be negative");
            }
            this.crossSectionPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for inCrossSection\n" : statusText + ex.getMessage() + "\n";
            this.crossSectionPanel.setBackground(Color.red);
        }
        if (this.opNormal.isSelected()) {
            this.cutTop.setEnabled(false);
            this.cutBottom.setEnabled(false);
        } else {
            this.cutTop.setEnabled(true);
            this.cutBottom.setEnabled(true);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(VolcanoGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(VolcanoGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(VolcanoGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(VolcanoGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new VolcanoGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

