/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.GearGenerator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class GearGeneratorGUI
extends JFrame {
    private Config configuration;
    private int outerRadius = 256;
    private int innerRadius = 224;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String outerRadiusTitle = "outerRadius";
    private String outerRadiusDescription = "The radius of the outside of the gear (where the teeth end).";
    private String innerRadiusTitle = "innerRadius";
    private String innerRadiusDescription = "The radius of where the teeth begin.";
    private String centreRadiusTitle = "centreRadius";
    private String centreRadiusDescription = "The radius of the inside hollow section of the gear. Can be 0. The gear is constructed such that an appropriately matched cylinder generated by the Cylinder Generator will fit perfectly inside this hole. Likewise for discs generated by the Disc Generator and corkscrews generated by the Corkscrew Generator.";
    private String outerThicknessTitle = "outerThickness";
    private String outerThicknessDescription = "The thickness of the teeth at the outside perimeter.";
    private String innerThicknessTitle = "innerThickness";
    private String innerThicknessDescription = "The thickness of the teeth at the inner radius.";
    private String centreThicknessTitle = "centreThickness";
    private String centreThicknessDescription = "The thickness of the gear at the beginning of the center hollow section.";
    private String teethTitle = "teeth";
    private String teethDescription = "The number of teeth the gear has.";
    private String outerToothLengthRatioTitle = "outerToothLengthRatio";
    private String outerToothLengthRatioDescription = "The ratio of the arc angle of outer tooth to the arc angle of the section that is missing after the tooth at the outer perimeter. Specify -1 to mean an infinite ratio.";
    private String innerToothLengthRatioTitle = "innerToothLengthRatio";
    private String innerToothLengthRatioDescription = "The ratio of the arc angle of inner tooth to the arc angle of the section that is missing after the tooth at the inner perimeter. Specify -1 to mean an infinite ratio.";
    private String offsetAngleTitle = "offsetAngle";
    private String offsetAngleDescription = "The angle, in degrees, by which to rotate the gear counter-clockwise. When this value is 0, the bottom inside of the first tooth will be touching the X axis.";
    private JPanel centreRadiusPanel;
    private JPanel centreThicknessPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JButton generate;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inCentreRadius;
    private JTextField inCentreThickness;
    private JTextField inInnerRadius;
    private JTextField inInnerThickness;
    private JTextField inInnerToothLengthRatio;
    private JTextField inOffsetAngle;
    private JTextField inOuterRadius;
    private JTextField inOuterThickness;
    private JTextField inOuterToothLengthRatio;
    private JTextField inTeeth;
    private JPanel innerRadiusPanel;
    private JPanel innerThicknessPanel;
    private JPanel innerToothLengthRatioPanel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labCentreRadius;
    private JLabel labInnerRadius;
    private JLabel labInnerThickness;
    private JLabel labInnerToothLengthRatio;
    private JLabel labOffsetAngle;
    private JLabel labOuterRadius;
    private JLabel labOuterThickness;
    private JLabel labOuterToothLengthRatio;
    private JLabel labTeeth;
    private JLabel labcentreThickness;
    private JPanel offsetAnglePanel;
    private ButtonGroup options;
    private JPanel outerRadiusPanel;
    private JPanel outerThicknessPanel;
    private JPanel outerToothLengthRatioPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel teethPanel;
    private JPanel valuesPanel;

    public GearGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.valuesPanel = new JPanel();
        this.outerRadiusPanel = new JPanel();
        this.labOuterRadius = new JLabel();
        this.inOuterRadius = new JTextField();
        this.innerThicknessPanel = new JPanel();
        this.labInnerThickness = new JLabel();
        this.inInnerThickness = new JTextField();
        this.centreRadiusPanel = new JPanel();
        this.labCentreRadius = new JLabel();
        this.inCentreRadius = new JTextField();
        this.outerThicknessPanel = new JPanel();
        this.labOuterThickness = new JLabel();
        this.inOuterThickness = new JTextField();
        this.teethPanel = new JPanel();
        this.labTeeth = new JLabel();
        this.inTeeth = new JTextField();
        this.centreThicknessPanel = new JPanel();
        this.labcentreThickness = new JLabel();
        this.inCentreThickness = new JTextField();
        this.innerRadiusPanel = new JPanel();
        this.labInnerRadius = new JLabel();
        this.inInnerRadius = new JTextField();
        this.outerToothLengthRatioPanel = new JPanel();
        this.inOuterToothLengthRatio = new JTextField();
        this.labOuterToothLengthRatio = new JLabel();
        this.innerToothLengthRatioPanel = new JPanel();
        this.inInnerToothLengthRatio = new JTextField();
        this.labInnerToothLengthRatio = new JLabel();
        this.offsetAnglePanel = new JPanel();
        this.labOffsetAngle = new JLabel();
        this.inOffsetAngle = new JTextField();
        this.setTitle("Gear Generator");
        this.setLocationByPlatform(true);
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/gear.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 486, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generate).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.statusScrollPane, -2, 41, -2).addComponent(this.generate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -1, 297, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates a gear as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, -1, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.outerRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.outerRadiusPanelFocusGained(evt);
            }
        });
        this.labOuterRadius.setLabelFor(this.inOuterRadius);
        this.labOuterRadius.setText("outerRadius:");
        this.inOuterRadius.setText("256");
        this.inOuterRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inOuterRadiusActionPerformed(evt);
            }
        });
        this.inOuterRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterRadiusFocusLost(evt);
            }
        });
        GroupLayout outerRadiusPanelLayout = new GroupLayout(this.outerRadiusPanel);
        this.outerRadiusPanel.setLayout(outerRadiusPanelLayout);
        outerRadiusPanelLayout.setHorizontalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterRadius, -2, 64, -2).addContainerGap()));
        outerRadiusPanelLayout.setVerticalGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOuterRadius).addComponent(this.inOuterRadius, -2, -1, -2)).addContainerGap()));
        this.labInnerThickness.setLabelFor(this.inInnerThickness);
        this.labInnerThickness.setText("innerThickness:");
        this.inInnerThickness.setText("64");
        this.inInnerThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inInnerThicknessActionPerformed(evt);
            }
        });
        this.inInnerThickness.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerThicknessFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerThicknessFocusLost(evt);
            }
        });
        GroupLayout innerThicknessPanelLayout = new GroupLayout(this.innerThicknessPanel);
        this.innerThicknessPanel.setLayout(innerThicknessPanelLayout);
        innerThicknessPanelLayout.setHorizontalGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labInnerThickness).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inInnerThickness, -2, 64, -2).addContainerGap()));
        innerThicknessPanelLayout.setVerticalGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(innerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labInnerThickness).addComponent(this.inInnerThickness, -2, -1, -2)).addContainerGap()));
        this.labCentreRadius.setLabelFor(this.inCentreRadius);
        this.labCentreRadius.setText("centreRadius:");
        this.inCentreRadius.setText("168");
        this.inCentreRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inCentreRadiusActionPerformed(evt);
            }
        });
        this.inCentreRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inCentreRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inCentreRadiusFocusLost(evt);
            }
        });
        GroupLayout centreRadiusPanelLayout = new GroupLayout(this.centreRadiusPanel);
        this.centreRadiusPanel.setLayout(centreRadiusPanelLayout);
        centreRadiusPanelLayout.setHorizontalGroup(centreRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(centreRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCentreRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCentreRadius, -2, 64, -2).addContainerGap()));
        centreRadiusPanelLayout.setVerticalGroup(centreRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, centreRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(centreRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCentreRadius).addComponent(this.inCentreRadius, -2, -1, -2)).addContainerGap()));
        this.labOuterThickness.setLabelFor(this.inOuterThickness);
        this.labOuterThickness.setText("outerThickness:");
        this.inOuterThickness.setText("48");
        this.inOuterThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inOuterThicknessActionPerformed(evt);
            }
        });
        this.inOuterThickness.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterThicknessFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterThicknessFocusLost(evt);
            }
        });
        GroupLayout outerThicknessPanelLayout = new GroupLayout(this.outerThicknessPanel);
        this.outerThicknessPanel.setLayout(outerThicknessPanelLayout);
        outerThicknessPanelLayout.setHorizontalGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterThickness).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterThickness, -2, 64, -2).addContainerGap()));
        outerThicknessPanelLayout.setVerticalGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outerThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOuterThickness).addComponent(this.inOuterThickness, -2, -1, -2))));
        this.labTeeth.setLabelFor(this.inInnerThickness);
        this.labTeeth.setText("teeth:");
        this.inTeeth.setText("24");
        this.inTeeth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inTeethActionPerformed(evt);
            }
        });
        this.inTeeth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inTeethFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inTeethFocusLost(evt);
            }
        });
        GroupLayout teethPanelLayout = new GroupLayout(this.teethPanel);
        this.teethPanel.setLayout(teethPanelLayout);
        teethPanelLayout.setHorizontalGroup(teethPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(teethPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labTeeth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inTeeth, -2, 64, -2).addContainerGap()));
        teethPanelLayout.setVerticalGroup(teethPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, teethPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(teethPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labTeeth).addComponent(this.inTeeth, -2, -1, -2)).addContainerGap()));
        this.labcentreThickness.setLabelFor(this.inInnerThickness);
        this.labcentreThickness.setText("centreThickness:");
        this.inCentreThickness.setText("32");
        this.inCentreThickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inCentreThicknessActionPerformed(evt);
            }
        });
        this.inCentreThickness.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inCentreThicknessFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inCentreThicknessFocusLost(evt);
            }
        });
        GroupLayout centreThicknessPanelLayout = new GroupLayout(this.centreThicknessPanel);
        this.centreThicknessPanel.setLayout(centreThicknessPanelLayout);
        centreThicknessPanelLayout.setHorizontalGroup(centreThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(centreThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labcentreThickness).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCentreThickness, -2, 64, -2).addContainerGap()));
        centreThicknessPanelLayout.setVerticalGroup(centreThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, centreThicknessPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(centreThicknessPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labcentreThickness).addComponent(this.inCentreThickness, -2, -1, -2)).addContainerGap()));
        this.innerRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.innerRadiusPanelFocusGained(evt);
            }
        });
        this.labInnerRadius.setLabelFor(this.inOuterRadius);
        this.labInnerRadius.setText("innerRadius:");
        this.inInnerRadius.setText("224");
        this.inInnerRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inInnerRadiusActionPerformed(evt);
            }
        });
        this.inInnerRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerRadiusFocusLost(evt);
            }
        });
        GroupLayout innerRadiusPanelLayout = new GroupLayout(this.innerRadiusPanel);
        this.innerRadiusPanel.setLayout(innerRadiusPanelLayout);
        innerRadiusPanelLayout.setHorizontalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labInnerRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inInnerRadius, -2, 64, -2).addContainerGap()));
        innerRadiusPanelLayout.setVerticalGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(innerRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labInnerRadius).addComponent(this.inInnerRadius, -2, -1, -2)).addContainerGap()));
        this.inOuterToothLengthRatio.setText("0.55");
        this.inOuterToothLengthRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inOuterToothLengthRatioActionPerformed(evt);
            }
        });
        this.inOuterToothLengthRatio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterToothLengthRatioFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inOuterToothLengthRatioFocusLost(evt);
            }
        });
        this.labOuterToothLengthRatio.setLabelFor(this.inInnerThickness);
        this.labOuterToothLengthRatio.setText("outerToothLengthRatio:");
        GroupLayout outerToothLengthRatioPanelLayout = new GroupLayout(this.outerToothLengthRatioPanel);
        this.outerToothLengthRatioPanel.setLayout(outerToothLengthRatioPanelLayout);
        outerToothLengthRatioPanelLayout.setHorizontalGroup(outerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerToothLengthRatioPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOuterToothLengthRatio).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOuterToothLengthRatio, -2, 64, -2).addContainerGap()));
        outerToothLengthRatioPanelLayout.setVerticalGroup(outerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, outerToothLengthRatioPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(outerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inOuterToothLengthRatio, -2, -1, -2).addComponent(this.labOuterToothLengthRatio)).addContainerGap()));
        this.inInnerToothLengthRatio.setText("1.6");
        this.inInnerToothLengthRatio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inInnerToothLengthRatioActionPerformed(evt);
            }
        });
        this.inInnerToothLengthRatio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerToothLengthRatioFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inInnerToothLengthRatioFocusLost(evt);
            }
        });
        this.labInnerToothLengthRatio.setLabelFor(this.inInnerThickness);
        this.labInnerToothLengthRatio.setText("innerToothLengthRatio:");
        GroupLayout innerToothLengthRatioPanelLayout = new GroupLayout(this.innerToothLengthRatioPanel);
        this.innerToothLengthRatioPanel.setLayout(innerToothLengthRatioPanelLayout);
        innerToothLengthRatioPanelLayout.setHorizontalGroup(innerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, innerToothLengthRatioPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labInnerToothLengthRatio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.inInnerToothLengthRatio, -2, 64, -2).addContainerGap()));
        innerToothLengthRatioPanelLayout.setVerticalGroup(innerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(innerToothLengthRatioPanelLayout.createSequentialGroup().addContainerGap().addGroup(innerToothLengthRatioPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inInnerToothLengthRatio, -2, -1, -2).addComponent(this.labInnerToothLengthRatio)).addContainerGap(-1, Short.MAX_VALUE)));
        this.labOffsetAngle.setLabelFor(this.inInnerThickness);
        this.labOffsetAngle.setText("offsetAngle:");
        this.inOffsetAngle.setText("0.0");
        this.inOffsetAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GearGeneratorGUI.this.inOffsetAngleActionPerformed(evt);
            }
        });
        this.inOffsetAngle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                GearGeneratorGUI.this.inOffsetAngleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                GearGeneratorGUI.this.inOffsetAngleFocusLost(evt);
            }
        });
        GroupLayout offsetAnglePanelLayout = new GroupLayout(this.offsetAnglePanel);
        this.offsetAnglePanel.setLayout(offsetAnglePanelLayout);
        offsetAnglePanelLayout.setHorizontalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOffsetAngle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOffsetAngle, -2, 64, -2).addContainerGap()));
        offsetAnglePanelLayout.setVerticalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOffsetAngle).addComponent(this.inOffsetAngle, -2, -1, -2)).addContainerGap()));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.innerRadiusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.outerRadiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.innerThicknessPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.outerThicknessPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.centreRadiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.centreThicknessPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.teethPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.outerToothLengthRatioPanel, -1, -1, Short.MAX_VALUE))).addComponent(this.innerToothLengthRatioPanel, -1, -1, Short.MAX_VALUE).addComponent(this.offsetAnglePanel, -1, -1, Short.MAX_VALUE))));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.outerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centreRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outerThicknessPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerThicknessPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.centreThicknessPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.teethPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.outerToothLengthRatioPanel, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.innerToothLengthRatioPanel, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetAnglePanel, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.subtitlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.statusPanel, -1, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionPanel, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.iconPanel, -2, -1, -2).addGap(40, 40, 40))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.descriptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.valuesPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2));
        this.pack();
    }

    private void inOuterRadiusFocusGained(FocusEvent evt) {
        this.outerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerRadiusTitle);
        this.description.setText(this.outerRadiusDescription);
    }

    private void inOuterRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void outerRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inInnerThicknessFocusGained(FocusEvent evt) {
        this.innerThicknessPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerThicknessTitle);
        this.description.setText(this.innerThicknessDescription);
    }

    private void inInnerThicknessFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inCentreRadiusFocusGained(FocusEvent evt) {
        this.centreRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.centreRadiusTitle);
        this.description.setText(this.centreRadiusDescription);
    }

    private void inCentreRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inOuterRadius.getText(), this.inInnerRadius.getText(), this.inCentreRadius.getText(), this.inOuterThickness.getText(), this.inInnerThickness.getText(), this.inCentreThickness.getText(), this.inTeeth.getText(), this.inOuterToothLengthRatio.getText(), this.inInnerToothLengthRatio.getText(), this.inOffsetAngle.getText()};
        this.status.setText("Generating gear...");
        GearGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void inInnerRadiusFocusGained(FocusEvent evt) {
        this.innerRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerRadiusTitle);
        this.description.setText(this.innerRadiusDescription);
    }

    private void inInnerRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void innerRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inOuterThicknessFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterThicknessFocusGained(FocusEvent evt) {
        this.outerThicknessPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerThicknessTitle);
        this.description.setText(this.outerThicknessDescription);
    }

    private void inOffsetAngleFocusGained(FocusEvent evt) {
        this.offsetAnglePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetAngleTitle);
        this.description.setText(this.offsetAngleDescription);
    }

    private void inOffsetAngleFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inOffsetAngleActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerThicknessActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterThicknessActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCentreRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCentreThicknessActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCentreThicknessFocusGained(FocusEvent evt) {
        this.centreThicknessPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.centreThicknessTitle);
        this.description.setText(this.centreThicknessDescription);
    }

    private void inCentreThicknessFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inTeethActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inTeethFocusGained(FocusEvent evt) {
        this.teethPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.teethTitle);
        this.description.setText(this.teethDescription);
    }

    private void inTeethFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterToothLengthRatioActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inOuterToothLengthRatioFocusGained(FocusEvent evt) {
        this.outerToothLengthRatioPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.outerToothLengthRatioTitle);
        this.description.setText(this.outerToothLengthRatioDescription);
    }

    private void inOuterToothLengthRatioFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerToothLengthRatioActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inInnerToothLengthRatioFocusGained(FocusEvent evt) {
        this.innerToothLengthRatioPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.innerToothLengthRatioTitle);
        this.description.setText(this.innerToothLengthRatioDescription);
    }

    private void inInnerToothLengthRatioFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inOuterRadius.getText());
            if (temp <= 1) {
                throw new Exception("outerRadius must be positive");
            }
            if (temp < this.innerRadius) {
                throw new Exception("outerRadius must be greater than or equal to innerRadius");
            }
            this.outerRadius = temp;
            this.outerRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerRadius\n" : statusText + ex.getMessage() + "\n";
            this.outerRadiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inInnerRadius.getText());
            if (temp < 0) {
                throw new Exception("innerRadius cannot be negative");
            }
            if (temp > this.outerRadius) {
                throw new Exception("innerRadius must be less than or equal to outerRadius");
            }
            this.innerRadius = temp;
            this.innerRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerRadius\n" : statusText + ex.getMessage() + "\n";
            this.innerRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inCentreRadius.getText());
            if (temp2 < 0) {
                throw new Exception("centreRadius cannot be negative");
            }
            this.centreRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for centreRadius\n" : statusText + ex.getMessage() + "\n";
            this.centreRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inOuterThickness.getText());
            if (temp3 < 0) {
                throw new Exception("outerThickness cannot be negative");
            }
            this.outerThicknessPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerThickness\n" : statusText + ex.getMessage() + "\n";
            this.outerThicknessPanel.setBackground(Color.red);
        }
        try {
            int temp4 = Integer.parseInt(this.inInnerThickness.getText());
            if (temp4 < 0) {
                throw new Exception("innerThickness cannot be negative");
            }
            this.innerThicknessPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerThickness\n" : statusText + ex.getMessage() + "\n";
            this.innerThicknessPanel.setBackground(Color.red);
        }
        try {
            int temp5 = Integer.parseInt(this.inCentreThickness.getText());
            if (temp5 < 0) {
                throw new Exception("centreThickness cannot be negative");
            }
            this.centreThicknessPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for centreThickness\n" : statusText + ex.getMessage() + "\n";
            this.centreThicknessPanel.setBackground(Color.red);
        }
        try {
            int temp6 = Integer.parseInt(this.inTeeth.getText());
            if (temp6 < 0) {
                throw new Exception("teeth cannot be negative");
            }
            this.teethPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for teeth\n" : statusText + ex.getMessage() + "\n";
            this.teethPanel.setBackground(Color.red);
        }
        try {
            double temp7 = Double.parseDouble(this.inOuterToothLengthRatio.getText());
            this.outerToothLengthRatioPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerToothLengthRatio\n" : statusText + ex.getMessage() + "\n";
            this.outerToothLengthRatioPanel.setBackground(Color.red);
        }
        try {
            double temp8 = Double.parseDouble(this.inInnerToothLengthRatio.getText());
            this.innerToothLengthRatioPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerToothLengthRatio\n" : statusText + ex.getMessage() + "\n";
            this.innerToothLengthRatioPanel.setBackground(Color.red);
        }
        try {
            double temp9 = Double.parseDouble(this.inOffsetAngle.getText());
            if (temp9 < 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.offsetAnglePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for the offsetAngle\n" : statusText + ex.getMessage() + "\n";
            this.offsetAnglePanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(GearGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(GearGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(GearGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(GearGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GearGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

