/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import generators.GenerationUtils;

public final class SineWaveGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int surfaceLength = Integer.parseInt(args[0]);
        int surfaceWidth = Integer.parseInt(args[1]);
        int slicesLength = Integer.parseInt(args[2]);
        int slicesWidth = Integer.parseInt(args[3]);
        int leftHeight = Integer.parseInt(args[4]);
        int leftAmplitude = Integer.parseInt(args[5]);
        int leftWavelength = Integer.parseInt(args[6]);
        double leftPhase = Double.parseDouble(args[7]);
        int rightHeight = Integer.parseInt(args[8]);
        int rightAmplitude = Integer.parseInt(args[9]);
        int rightWavelength = Integer.parseInt(args[10]);
        double rightPhase = Double.parseDouble(args[11]);
        Point3D[][] mesh = new Point3D[slicesLength + 1][slicesWidth + 1];
        Point3D[] leftCurve = new Point3D[slicesLength + 1];
        Point3D[] rightCurve = new Point3D[slicesLength + 1];
        double step = (double)surfaceLength / (double)slicesLength;
        double leftThetaPerStep = Math.PI * 2 / ((double)leftWavelength / step);
        double rightThetaPerStep = Math.PI * 2 / ((double)rightWavelength / step);
        double currLeftTheta = leftPhase * 2.0 * Math.PI;
        double currRightTheta = rightPhase * 2.0 * Math.PI;
        for (int i = 0; i <= slicesLength; ++i) {
            leftCurve[i] = new Point3D(0.0, (double)i * step, (double)leftHeight + Math.sin(currLeftTheta) * (double)leftAmplitude);
            rightCurve[i] = new Point3D(surfaceWidth, (double)i * step, (double)rightHeight + Math.sin(currRightTheta) * (double)rightAmplitude);
            currLeftTheta += leftThetaPerStep;
            currRightTheta += rightThetaPerStep;
        }
        for (int i = 0; i <= slicesLength; ++i) {
            for (int j = 0; j <= slicesWidth; ++j) {
                mesh[i][j] = new Point3D(leftCurve[i].x + (rightCurve[i].x - leftCurve[i].x) * ((double)j / (double)slicesWidth), leftCurve[i].y + (rightCurve[i].y - leftCurve[i].y) * ((double)j / (double)slicesWidth), leftCurve[i].z + (rightCurve[i].z - leftCurve[i].z) * ((double)j / (double)slicesWidth));
            }
        }
        SineWaveGenerator.startMap();
        for (int i = 0; i < slicesLength; ++i) {
            for (int j = 0; j < slicesWidth; ++j) {
                SineWaveGenerator.writeBrushExtendZ(0, mesh[i][j + 1], mesh[i][j], mesh[i + 1][j], false);
                SineWaveGenerator.writeBrushExtendZ(0, mesh[i + 1][j], mesh[i + 1][j + 1], mesh[i][j + 1], false);
            }
        }
        SineWaveGenerator.endMap();
    }
}

