/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class GearGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int innerRadius = Integer.parseInt(args[1]);
        int centerRadius = Integer.parseInt(args[2]);
        int outerThickness = Integer.parseInt(args[3]);
        int innerThickness = Integer.parseInt(args[4]);
        int centerThickness = Integer.parseInt(args[5]);
        int teeth = Integer.parseInt(args[6]);
        double outerToothLengthRatio = Double.parseDouble(args[7]);
        double innerToothLengthRatio = Double.parseDouble(args[8]);
        double offsetAngle = Double.parseDouble(args[9]);
        Point3D[][] outerPts = new Point3D[teeth * 2][2];
        Point3D[][] innerPts = new Point3D[teeth * 2][2];
        Point3D[][] centerPts = new Point3D[teeth * 2][2];
        innerPts[0][0] = new Point3D(innerRadius, 0.0, (double)innerThickness / 2.0);
        innerPts[0][1] = new Point3D(innerRadius, 0.0, -((double)innerThickness) / 2.0);
        double theta = Math.PI * 2 / (double)teeth;
        double alpha = innerToothLengthRatio < 0.0 ? theta : innerToothLengthRatio * theta / (innerToothLengthRatio + 1.0);
        AxisRotation3D rot = new AxisRotation3D(4, alpha);
        innerPts[1][0] = rot.transform(innerPts[0][0]);
        innerPts[1][1] = rot.transform(innerPts[0][1]);
        outerPts[0][0] = new Point3D(outerRadius, 0.0, (double)outerThickness / 2.0);
        outerPts[0][1] = new Point3D(outerRadius, 0.0, -((double)outerThickness) / 2.0);
        double beta = outerToothLengthRatio < 0.0 ? theta : outerToothLengthRatio * theta / (outerToothLengthRatio + 1.0);
        rot = new AxisRotation3D(4, (alpha - beta) / 2.0);
        outerPts[0][0] = rot.transform(outerPts[0][0]);
        outerPts[0][1] = rot.transform(outerPts[0][1]);
        rot = new AxisRotation3D(4, beta);
        outerPts[1][0] = rot.transform(outerPts[0][0]);
        outerPts[1][1] = rot.transform(outerPts[0][1]);
        centerPts[0][0] = new Point3D(centerRadius, 0.0, (double)centerThickness / 2.0);
        centerPts[0][1] = new Point3D(centerRadius, 0.0, -((double)centerThickness) / 2.0);
        rot = new AxisRotation3D(4, theta / 2.0);
        centerPts[1][0] = rot.transform(centerPts[0][0]);
        centerPts[1][1] = rot.transform(centerPts[0][1]);
        for (int i = 1; i < teeth; ++i) {
            rot = new AxisRotation3D(4, theta * (double)i);
            outerPts[i * 2][0] = rot.transform(outerPts[0][0]);
            outerPts[i * 2][1] = rot.transform(outerPts[0][1]);
            outerPts[i * 2 + 1][0] = rot.transform(outerPts[1][0]);
            outerPts[i * 2 + 1][1] = rot.transform(outerPts[1][1]);
            innerPts[i * 2][0] = rot.transform(innerPts[0][0]);
            innerPts[i * 2][1] = rot.transform(innerPts[0][1]);
            innerPts[i * 2 + 1][0] = rot.transform(innerPts[1][0]);
            innerPts[i * 2 + 1][1] = rot.transform(innerPts[1][1]);
            centerPts[i * 2][0] = rot.transform(centerPts[0][0]);
            centerPts[i * 2][1] = rot.transform(centerPts[0][1]);
            centerPts[i * 2 + 1][0] = rot.transform(centerPts[1][0]);
            centerPts[i * 2 + 1][1] = rot.transform(centerPts[1][1]);
        }
        if (offsetAngle != 0.0) {
            double radians = Math.PI * offsetAngle / 180.0;
            rot = new AxisRotation3D(4, radians);
            for (int i = 0; i < teeth * 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    outerPts[i][j] = rot.transform(outerPts[i][j]);
                    innerPts[i][j] = rot.transform(innerPts[i][j]);
                    centerPts[i][j] = rot.transform(centerPts[i][j]);
                }
            }
        }
        GearGenerator.startMap();
        for (int i = 0; i < teeth; ++i) {
            if (outerToothLengthRatio != 0.0) {
                GearGenerator.writeWedge(outerPts[i * 2 + 1][0], outerPts[i * 2][0], innerPts[i * 2][0], outerPts[i * 2 + 1][1], outerPts[i * 2][1], innerPts[i * 2][1]);
            }
            if (innerToothLengthRatio != 0.0) {
                GearGenerator.writeWedge(outerPts[i * 2 + 1][0], innerPts[i * 2][0], innerPts[i * 2 + 1][0], outerPts[i * 2 + 1][1], innerPts[i * 2][1], innerPts[i * 2 + 1][1]);
                GearGenerator.writeWedge(innerPts[i * 2 + 1][0], innerPts[i * 2][0], centerPts[i * 2][0], innerPts[i * 2 + 1][1], innerPts[i * 2][1], centerPts[i * 2][1]);
            }
            if (centerRadius != 0) {
                GearGenerator.writeWedge(innerPts[i * 2 + 1][0], centerPts[i * 2][0], centerPts[i * 2 + 1][0], innerPts[i * 2 + 1][1], centerPts[i * 2][1], centerPts[i * 2 + 1][1]);
            }
            if (!(innerToothLengthRatio < 0.0)) {
                GearGenerator.writeWedge(innerPts[i == teeth - 1 ? 0 : i * 2 + 2][0], innerPts[i * 2 + 1][0], centerPts[i * 2 + 1][0], innerPts[i == teeth - 1 ? 0 : i * 2 + 2][1], innerPts[i * 2 + 1][1], centerPts[i * 2 + 1][1]);
            }
            if (centerRadius == 0) continue;
            GearGenerator.writeWedge(centerPts[i * 2 + 1][0], centerPts[i == teeth - 1 ? 0 : i * 2 + 2][0], innerPts[i == teeth - 1 ? 0 : i * 2 + 2][0], centerPts[i * 2 + 1][1], centerPts[i == teeth - 1 ? 0 : i * 2 + 2][1], innerPts[i == teeth - 1 ? 0 : i * 2 + 2][1]);
        }
        GearGenerator.endMap();
    }
}

