/*
 * Decompiled with CFR 0.152.
 */
package com.nerius.math.xform;

import com.nerius.math.xform.AffineTransform3D;
import com.nerius.math.xform.Matrix4x4;

public class GeneralRotation3D
extends AffineTransform3D {
    public GeneralRotation3D(double vectorX, double vectorY, double vectorZ, double theta) {
        super(GeneralRotation3D.getGeneralRotationMatrix(vectorX, vectorY, vectorZ, theta));
    }

    private static Matrix4x4 getGeneralRotationMatrix(double x, double y, double z, double theta) {
        double axisLength = Math.sqrt(x * x + y * y + z * z);
        if (axisLength == 0.0) {
            throw new IllegalArgumentException("length of rotation axis is 0");
        }
        double sinTh = Math.sin(theta);
        double oneMinCosTh = 1.0 - Math.cos(theta);
        return new Matrix4x4(new double[][]{{1.0 - oneMinCosTh * ((z /= axisLength) * z + (y /= axisLength) * y), -z * sinTh + (x /= axisLength) * y * oneMinCosTh, y * sinTh + z * x * oneMinCosTh, 0.0}, {z * sinTh + x * y * oneMinCosTh, 1.0 - oneMinCosTh * (z * z + x * x), -x * sinTh + z * y * oneMinCosTh, 0.0}, {-y * sinTh + z * x * oneMinCosTh, x * sinTh + z * y * oneMinCosTh, 1.0 - oneMinCosTh * (y * y + x * x), 0.0}, {0.0, 0.0, 0.0, 1.0}});
    }
}

