unit Path;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFormPath = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EditInstall: TEdit;
    EditMap: TEdit;
    EditOutput: TEdit;
    BtnInstall: TButton;
    BtnMap: TButton;
    BtnOutput: TButton;
    BtnOK: TButton;
    procedure FormCreate(Sender: TObject);
    procedure BtnInstallClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure BtnMapClick(Sender: TObject);
    procedure BtnOutputClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormPath: TFormPath;

implementation

uses
   PathDlg,
   IniFiles,
   Main;       // uses MyDir, KingpinInstallDir, DefaultOutputDir, DefaultMapDir

{$R *.dfm}

{==============================================================================}
procedure TFormPath.FormCreate(Sender: TObject);
var
  MyIni: TIniFile;
begin
  MyIni := TIniFile.Create(MyDir+'\kpcmf.ini');
  EditInstall.Text := MyIni.ReadString('Path','KingpinInstallDir','');
  EditOutput.Text := MyIni.ReadString('Path','DefaultOutputDir','');
  EditMap.Text := MyIni.ReadString('Path','DefaultMapDir','');
  MyIni.Free;
end;

{==============================================================================}
procedure TFormPath.BtnOKClick(Sender: TObject);
var
  Ok : Boolean;
  MyIni : TIniFile;
begin
  Ok := True;
  if EditInstall.Text = '' then
  begin
    MessageDlg('Incomplete Kingpin Install Directory!', mtError, [mbOK], 0);
    Ok := False;
  end
  else if EditOutput.Text = '' then
  begin
    MessageDlg('Incomplete Output Directory!', mtError, [mbOK], 0);
    Ok := False;
  end
  else if EditMap.Text = '' then
  begin
    MessageDlg('Incomplete Map Directory!', mtError, [mbOK], 0);
    Ok := False;
  end;
  if Ok then
  begin
    MyIni := TIniFile.Create(MyDir+'\kpcmf.ini');
    MyIni.WriteString('Path','KingpinInstallDir',EditInstall.Text);
    KingpinInstallDir := EditInstall.Text;
    MyIni.WriteString('Path','DefaultOutputDir',EditOutput.Text);
    DefaultOutputDir := EditOutput.Text;
    MyIni.WriteString('Path','DefaultMapDir',EditMap.Text);
    DefaultMapDir := EditMap.Text;
    MyIni.Free;
    ModalResult := mrOK;
  end;
end;

{==============================================================================}
procedure TFormPath.BtnInstallClick(Sender: TObject);
begin
  FormPathDlg := TFormPathDlg.Create(self);
  try
    FormPathDlg.Caption := 'Select Kingpin Install Directory';
    FormPathDlg.BtnCreate.Visible := False;
    FormPathDlg.EditDir.Visible := False;

    if DirectoryExists(EditInstall.Text) then
      FormPathDlg.DirectoryListBox.Directory := EditInstall.Text;

    FormPathDlg.ShowModal;

    EditInstall.Text := FormPathDlg.DirectoryListBox.Directory;
    if EditMap.Text = '' then
      EditMap.Text := FormPathDlg.DirectoryListBox.Directory + '\main\maps';

  finally
    FormPathDlg.free;
  end;
end;

{==============================================================================}
procedure TFormPath.BtnMapClick(Sender: TObject);
begin
  FormPathDlg := TFormPathDlg.Create(self);
  try
    FormPathDlg.Caption := 'Select Default Map Directory';

    if DirectoryExists(EditMap.Text) then
      FormPathDlg.DirectoryListBox.Directory := EditMap.Text;

    // Refer to install path first
    if DirectoryExists(EditInstall.Text) and (EditMap.Text = '') then
      FormPathDlg.DirectoryListBox.Directory := EditInstall.Text;

    FormPathDlg.ShowModal;
    EditMap.Text := FormPathDlg.DirectoryListBox.Directory;
  finally
    FormPathDlg.free;
  end;
end;

{==============================================================================}
procedure TFormPath.BtnOutputClick(Sender: TObject);
begin
  FormPathDlg := TFormPathDlg.Create(self);
  try
    FormPathDlg.Caption := 'Select Default Output Directory';

    if DirectoryExists(EditOutput.Text) then
      FormPathDlg.DirectoryListBox.Directory := EditOutput.Text;

    // Refer to install path first
    if DirectoryExists(EditInstall.Text) and (EditMap.Text = '') then
      FormPathDlg.DirectoryListBox.Directory := EditInstall.Text;

    FormPathDlg.ShowModal;
    EditOutput.Text := FormPathDlg.DirectoryListBox.Directory;
  finally
    FormPathDlg.free;
  end;
end;

end.
