/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Vector3f {
    static final int BYTELEN = 4;
    static final int NUMVALS = 3;
    float x;
    float y;
    float z;

    public Vector3f(ByteBuffer b) {
        byte[] backing = new byte[12];
        b.get(backing);
        ByteBuffer temp = ByteBuffer.wrap(backing);
        temp.order(ByteOrder.LITTLE_ENDIAN);
        this.x = temp.getFloat();
        this.y = temp.getFloat();
        this.z = temp.getFloat();
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public String toStringRounded() {
        return Math.round(this.x) + ", " + Math.round(this.y) + ", " + Math.round(this.z);
    }

    public byte[] toBytes() {
        byte[] backing = new byte[12];
        ByteBuffer b = ByteBuffer.wrap(backing);
        b.putFloat(this.x);
        b.putFloat(this.y);
        b.putFloat(this.z);
        return backing;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }
}

