/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.vdf;

import com.technofovea.hl2parse.JxPathUtil;
import com.technofovea.hl2parse.vdf.VdfAttribute;
import com.technofovea.hl2parse.vdf.VdfRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameConfigReader {
    static final String ROOT_NODE = "Configs";
    static final String GAME_NODE = "Games";
    static final String KEY_GAMEDIR = "GameDir";
    static final String NODE_HAMMER = "hammer";
    static final String KEY_MAPFORMAT = "MapFormat";
    static final String KEY_MAPSRC = "MapDir";
    static final String KEY_MAPDEST = "BspDir";
    static final String PREFIX_FGDS = "GameData";
    static final String KEY_SDKVERSION = "SDKVersion";
    private static final Logger logger = LoggerFactory.getLogger(GameConfigReader.class);
    VdfRoot root;
    JXPathContext context;
    Map<String, Game> games = new HashMap<String, Game>();
    int sdkVersion;

    public GameConfigReader(VdfRoot rootNode) {
        this.root = rootNode;
        this.context = JXPathContext.newContext((Object)this.root);
        JxPathUtil.addFunctions(this.context);
        this.context.getVariables().declareVariable("rootname", (Object)ROOT_NODE);
        this.context.getVariables().declareVariable("gamegroup", (Object)GAME_NODE);
        this.context.getVariables().declareVariable("sdkver", (Object)KEY_SDKVERSION);
        logger.trace("Checking file for defined games...");
        for (Pointer p : this.getGamePointers()) {
            JXPathContext relativeContext = this.context.getRelativeContext(p);
            Game g = new Game(relativeContext);
            logger.trace("Found game: {}", (Object)g.getName());
            this.games.put(g.getName(), g);
        }
        try {
            this.sdkVersion = new Integer((String)this.context.getValue("children[custom:equals(name,$rootname)]/attributes[custom:equals(name,$sdkver)]/value"));
        }
        catch (JXPathException jex) {
            logger.warn("Unable to determine SDK version in game-config", (Throwable)jex);
            this.sdkVersion = -1;
        }
    }

    List<Pointer> getGamePointers() {
        ArrayList<Pointer> ret = new ArrayList<Pointer>();
        Iterator iter = this.context.iteratePointers("children[custom:equals(name,$rootname)]/children[custom:equals(name,$gamegroup)]/children[*]");
        while (iter.hasNext()) {
            ret.add((Pointer)iter.next());
        }
        return ret;
    }

    public Map<String, Game> getGames() {
        return new HashMap<String, Game>(this.games);
    }

    public int getSdkVersion() {
        return this.sdkVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Game {
        String name;
        List<File> fgds = new ArrayList<File>();
        File gameDir;
        int mapFormat;
        File vmfDir;
        File bspDir;

        Game(JXPathContext relativeContext) {
            relativeContext.getVariables().declareVariable("gamedir", (Object)GameConfigReader.KEY_GAMEDIR);
            relativeContext.getVariables().declareVariable("hammeropts", (Object)GameConfigReader.NODE_HAMMER);
            relativeContext.getVariables().declareVariable("mapformat", (Object)GameConfigReader.KEY_MAPFORMAT);
            relativeContext.getVariables().declareVariable("vmfdir", (Object)GameConfigReader.KEY_MAPSRC);
            relativeContext.getVariables().declareVariable("bspdir", (Object)GameConfigReader.KEY_MAPDEST);
            relativeContext.getVariables().declareVariable("fgdprefix", (Object)GameConfigReader.PREFIX_FGDS);
            this.name = (String)relativeContext.getValue("name");
            this.gameDir = new File((String)relativeContext.getValue("attributes[custom:equals(name,$gamedir)]/value"));
            this.mapFormat = Integer.parseInt((String)relativeContext.getValue("children[custom:equals(name,$hammeropts)]/attributes[custom:equals(name,$mapformat)]/value"));
            this.vmfDir = new File((String)relativeContext.getValue("children[custom:equals(name,$hammeropts)]/attributes[custom:equals(name,$vmfdir)]/value"));
            this.bspDir = new File((String)relativeContext.getValue("children[custom:equals(name,$hammeropts)]/attributes[custom:equals(name,$bspdir)]/value"));
            Iterator attrs = relativeContext.iterate("children[custom:equals(name,$hammeropts)]/attributes[custom:startswith(name,$fgdprefix)]");
            TreeMap<Integer, String> fgdOrder = new TreeMap<Integer, String>();
            while (attrs.hasNext()) {
                VdfAttribute a = (VdfAttribute)attrs.next();
                assert (a.getName().toLowerCase().startsWith(GameConfigReader.PREFIX_FGDS.toLowerCase()));
                String numericPart = a.getName().substring(GameConfigReader.PREFIX_FGDS.length());
                try {
                    Integer intVal = new Integer(numericPart);
                    fgdOrder.put(intVal, a.getValue());
                }
                catch (NumberFormatException e) {}
            }
            this.fgds = new ArrayList<File>();
            for (String path : fgdOrder.values()) {
                this.fgds.add(new File(path));
            }
        }

        public File getBspDir() {
            return this.bspDir;
        }

        public List<File> getFgds() {
            return new ArrayList<File>(this.fgds);
        }

        public File getGameDir() {
            return this.gameDir;
        }

        public int getMapFormat() {
            return this.mapFormat;
        }

        public String getName() {
            return this.name;
        }

        public File getVmfDir() {
            return this.vmfDir;
        }
    }
}

