/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.bsp;

import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.bsp.BspParseException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameLumpHeader {
    private static final Logger logger = LoggerFactory.getLogger(GameLumpHeader.class);
    private int offset;
    private int length;
    private short version;
    private short flags;
    private final int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GameLumpHeader(ByteBuffer lumpSection) throws BspParseException {
        int originalPosition = lumpSection.position();
        boolean resetPosition = true;
        try {
            this.id = lumpSection.getInt();
            this.flags = lumpSection.getShort();
            this.version = lumpSection.getShort();
            this.offset = lumpSection.getInt();
            this.length = lumpSection.getInt();
            if (this.offset < 0) {
                throw new BspParseException("Game lump header has negative offset");
            }
            if (this.length < 0) {
                throw new BspParseException("Game lump header has negative length");
            }
            if (logger.isDebugEnabled()) {
                String hexName = ParseUtil.toAscii(this.id, true);
                logger.debug("Game-lump created. ID {} ({}), version {}, offset {}, length {}", new Object[]{this.id, hexName, this.version, this.offset, this.length});
            }
            resetPosition = false;
        }
        finally {
            if (resetPosition) {
                lumpSection.position(originalPosition);
            }
        }
    }

    public static int stringToId(String str) {
        if (str.length() > 4) {
            logger.error("Game-lump 'hex label' was greater than four digits: " + str);
            return -1;
        }
        StringBuilder sb = new StringBuilder(str);
        sb.reverse();
        byte[] bytes = sb.toString().getBytes();
        if (bytes.length < 4) {
            bytes = Arrays.copyOf(bytes, 4);
        }
        ByteBuffer temp = ByteBuffer.wrap(bytes);
        return temp.getInt();
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public short getVersion() {
        return this.version;
    }

    public short getFlags() {
        return this.flags;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GameLumpHeader other = (GameLumpHeader)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.version != other.version) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        return this.id == other.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.offset;
        hash = 73 * hash + this.length;
        hash = 73 * hash + this.version;
        hash = 73 * hash + this.flags;
        hash = 73 * hash + this.id;
        return hash;
    }
}

