/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.bsp;

import com.technofovea.hl2parse.OffsetBuffer;
import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.bsp.BinaryBspAnalyzer;
import com.technofovea.hl2parse.bsp.BspParseException;
import com.technofovea.hl2parse.bsp.GameLumpHeader;
import com.technofovea.hl2parse.bsp.GamePropSection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMapAnalyzer
extends BinaryBspAnalyzer {
    protected static final int TRANSFER_BUF_SIZE = 5192;
    private static final Logger logger = LoggerFactory.getLogger(SourceMapAnalyzer.class);
    protected static final Charset CHARSET = Charset.forName("ASCII");
    protected static byte[] EXPECTED_HEADER = "VBSP".getBytes();
    protected static int[] EXPECTED_VERSIONS = new int[]{19, 20};
    public static int NUM_LUMPS = 64;
    public static int LUMP_ENTITIES = 0;
    public static int LUMP_PAKFILE = 40;
    public static int LUMP_MATERIALOFFSETS = 44;
    public static int LUMP_MATERIALNAMES = 43;
    public static int PROP_DICT_ENTRY_LEN = 128;
    public static int LUMP_SOURCESPECIFIC = 35;
    public static String GAMELUMP_PROPS = "prps";
    public static String GAMELUMP_PROPS_DETAIL = "prpd";
    protected List<String> materialNames = new ArrayList<String>();
    protected String entData;
    protected OffsetBuffer gameLumpData;
    protected GameLumpHeader[] gameLumpHeaders;
    protected List<String> staticPropNames = new ArrayList<String>();
    protected HashMap<String, Set<Integer>> staticPropSkins;
    protected ZipFile packedZip = null;
    protected Map<String, File> extractedFiles = new HashMap<String, File>();

    public SourceMapAnalyzer(ByteBuffer bb) throws BspParseException {
        super(bb);
        try {
            this.loadGameLumps();
            this.loadTextures();
            this.loadEntityData();
            this.loadStaticPropData();
        }
        catch (BufferUnderflowException ex) {
            throw new BspParseException(ex);
        }
    }

    @Override
    protected byte[] getInitialHeader() {
        return EXPECTED_HEADER;
    }

    @Override
    protected int getNumLumps() {
        return NUM_LUMPS;
    }

    @Override
    protected boolean handlesVersion(int version) {
        for (int v : EXPECTED_VERSIONS) {
            if (v != version) continue;
            return true;
        }
        return false;
    }

    private void loadTextures() {
        ArrayList<Integer> materialNameOffsets = new ArrayList<Integer>();
        logger.debug("Loading world brush textures from lump {}", (Object)LUMP_MATERIALOFFSETS);
        OffsetBuffer matOffsetZone = this.getLumpData(LUMP_MATERIALOFFSETS);
        while (matOffsetZone.getBuf().remaining() > 0) {
            materialNameOffsets.add(matOffsetZone.getBuf().getInt());
        }
        OffsetBuffer nameZone = this.getLumpData(LUMP_MATERIALNAMES);
        Iterator i$ = materialNameOffsets.iterator();
        while (i$.hasNext()) {
            int offset = (Integer)i$.next();
            nameZone.getBuf().position(offset);
            String name = ParseUtil.readString(nameZone.getBuf(), 512);
            name = "materials/" + name;
            this.materialNames.add(SourceMapAnalyzer.sanitizePath(name));
        }
    }

    protected String bufToAscii(ByteBuffer buf) {
        CharBuffer cb = CHARSET.decode(buf.asReadOnlyBuffer());
        cb.clear();
        char nullByte = '\u0000';
        while (cb.remaining() > 0 && nullByte != cb.charAt(0)) {
            cb.position(cb.position() + 1);
        }
        cb.flip();
        String ret = cb.toString();
        assert (!ret.endsWith("\u0000"));
        return ret;
    }

    private void loadEntityData() {
        logger.debug("Loading entity data from lump {}", (Object)LUMP_ENTITIES);
        OffsetBuffer entZone = this.getLumpData(LUMP_ENTITIES);
        this.entData = this.bufToAscii(entZone.getBuf());
    }

    private void loadGameLumps() throws BspParseException {
        logger.debug("Loading lump {} containing game-lumps", (Object)LUMP_SOURCESPECIFIC);
        this.gameLumpData = this.getLumpData(LUMP_SOURCESPECIFIC);
        int lumpCount = this.gameLumpData.getBuf().getInt();
        logger.debug("Game lump count {}", (Object)lumpCount);
        this.gameLumpHeaders = new GameLumpHeader[lumpCount];
        for (int i = 0; i < lumpCount; ++i) {
            GameLumpHeader hdr;
            logger.trace("Loading game-lump header #{}", (Object)i);
            this.gameLumpHeaders[i] = hdr = new GameLumpHeader(this.gameLumpData.getBuf());
        }
    }

    protected GameLumpHeader getGameLump(int lumpId) {
        GameLumpHeader hdr = null;
        for (int i = 0; i < this.gameLumpHeaders.length; ++i) {
            GameLumpHeader temp = this.gameLumpHeaders[i];
            if (temp.getId() != lumpId) continue;
            hdr = temp;
            break;
        }
        if (hdr == null) {
            logger.error("Game-lump {} could not be found", (Object)lumpId);
        }
        return hdr;
    }

    protected OffsetBuffer getGameLumpData(int lumpId) {
        GameLumpHeader hdr = this.getGameLump(lumpId);
        if (hdr == null) {
            return null;
        }
        return new OffsetBuffer(this.gameLumpData.getParent(), hdr.getOffset(), hdr.getLength());
    }

    protected void loadStaticPropData() {
        int id = GameLumpHeader.stringToId(GAMELUMP_PROPS);
        logger.debug("Loading static prop data from gamelump {} ({})", (Object)GAMELUMP_PROPS, (Object)id);
        GameLumpHeader hdr = this.getGameLump(id);
        OffsetBuffer propLumpData = this.getGameLumpData(id);
        int numDictEntries = propLumpData.getBuf().getInt();
        logger.debug("Propname dictionary entry count {}", (Object)numDictEntries);
        byte[] strBuf = new byte[PROP_DICT_ENTRY_LEN];
        for (int i = 0; i < numDictEntries; ++i) {
            propLumpData.getBuf().get(strBuf);
            String name = ParseUtil.readString(strBuf, strBuf.length);
            name = SourceMapAnalyzer.sanitizePath(name);
            this.staticPropNames.add(name);
        }
        int totalLeafEntries = propLumpData.getBuf().getInt();
        logger.debug("Prop leaf entry count {}", (Object)totalLeafEntries);
        for (int i = 0; i < totalLeafEntries; ++i) {
            short leaf = propLumpData.getBuf().getShort();
        }
        this.staticPropSkins = new HashMap();
        int propCount = propLumpData.getBuf().getInt();
        logger.debug("Prop usage count {}", (Object)propCount);
        for (int i = 0; i < propCount; ++i) {
            logger.trace("Loading prop instance #{}", (Object)i);
            GamePropSection section = new GamePropSection(hdr, propLumpData.getBuf());
            int propNameIndex = section.getPropNameIndex();
            int skin = section.getSkin();
            if (propNameIndex < 0 || propNameIndex >= this.staticPropNames.size()) {
                logger.error("Prop instance specifies a name index ({}) which is invalid", (Object)propNameIndex);
            }
            String propName = this.staticPropNames.get(propNameIndex);
            logger.trace("Prop named '{}' ({}) with skin {} ", new Object[]{propName, propNameIndex, skin});
            if (this.staticPropSkins.containsKey(propName)) {
                this.staticPropSkins.get(propName).add(skin);
                continue;
            }
            HashSet<Integer> skinsUsed = new HashSet<Integer>();
            skinsUsed.add(skin);
            this.staticPropSkins.put(propName, skinsUsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile getPackedFiles() throws IOException {
        SourceMapAnalyzer sourceMapAnalyzer = this;
        synchronized (sourceMapAnalyzer) {
            if (this.packedZip == null) {
                logger.debug("Initializing temp file for extracting packed BSP data");
                File tempfile = File.createTempFile("packbsp_pak_", ".zip");
                tempfile.deleteOnExit();
                logger.debug("Temp file at: {}", (Object)tempfile.getAbsolutePath());
                tempfile.deleteOnExit();
                OffsetBuffer buf = this.getLumpData(LUMP_PAKFILE);
                FileChannel fc = new FileOutputStream(tempfile, false).getChannel();
                fc.write(buf.getBuf());
                fc.close();
                this.packedZip = new ZipFile(tempfile, 1);
            }
        }
        return this.packedZip;
    }

    public File getPackedFile(String path) throws IOException {
        if (this.extractedFiles.containsKey(path = path.toLowerCase())) {
            logger.debug("Packed file {} was already extracted once, returning cached File reference", (Object)path);
            return this.extractedFiles.get(path);
        }
        ZipFile zf = this.getPackedFiles();
        ZipEntry found = null;
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            if (!entry.getName().equalsIgnoreCase(path)) continue;
            logger.debug("Packed file found in zip data: ", (Object)entry.getName());
            found = entry;
            break;
        }
        if (found == null) {
            logger.debug("Packed file {} could not be found in zip data.", (Object)path);
            return null;
        }
        File tempfile = File.createTempFile("packbsp_extracted_", ".file");
        tempfile.deleteOnExit();
        InputStream is = zf.getInputStream(found);
        FileOutputStream fos = new FileOutputStream(tempfile);
        byte[] buffer = new byte[5192];
        int numRead = 0;
        while (numRead > -1) {
            fos.write(buffer, 0, numRead);
            numRead = is.read(buffer);
        }
        fos.close();
        logger.debug("Packed file {} extracted to location: {}", (Object)path, (Object)tempfile.getAbsolutePath());
        this.extractedFiles.put(path, tempfile);
        return tempfile;
    }

    public Set<String> getBrushTextures() {
        return new HashSet<String>(this.materialNames);
    }

    public String getEntData() {
        return this.entData;
    }

    public HashMap<String, Set<Integer>> getStaticPropSkins() {
        return this.staticPropSkins;
    }

    static String sanitizePath(String path) {
        path = path.toLowerCase().trim();
        path.replace("\\", "/");
        return path;
    }
}

