/*
MergeT3D - Quest .map to Unreal .t3d converter

merget3d.c file of the MergeT3D Source Code

Copyright 1997, 1998 Alexander Malmberg
Copyright Gyro Gearloose
Copyright 1996, Trey Harrison and Chris Carollo


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "types.h"

#include "error.h"
#include "globals.h"
#include "map.h"
#include "memory.h"
#include "t3d.h"


brush_t  *BrushHead = NULL;  //head of linked list of brushes
entity_t *EntityHead = NULL; //head of linked list of entities
entity_t *WorldSpawn = NULL; //points to the worldspawn entity

int  num_brushes  = 0;
int  num_entities = 0;

char texturename[256]; //holds texture name
char mapfilename[256]; //holds map file name
char t3dfilename[256]; //holds t3d file name
char outfilename[256]; //holds output file name

// Global variables used for loading texture data from T3D file
FILE * t3dfp;
char t3dline[1024];
char * t3dpos;
int num_tpolys = 0;	// Number of polys with texture data loaded from T3D file
int num_tused = 0;	// Number of poly texture data elements we were able to use
vec3_t location;
t3d_texture_t *first_t3d_texture = NULL;
t3d_texture_t *last_t3d_texture = NULL;
int t3d_linenumber = 0;


int main(int argc,char **argv)
{
	printf("\n"
	       "MergeT3D 1.2 - .MAP/.T3D to .T3D merge utility.\n"
	       "\n"
          "Copyright 1998 Alexander Malmberg <alexander@malmberg.org>\n"
          "Copyright Gyro Gearloose\n"
          "Copyright 1996, 1996 Chris Carollo and Trey Harrison\n"
          "\n"
          "This program is distributed under the terms of the GNU General Public\n"
          "License as published by the Free Software Foundation. A copy of it is in\n"
          "the file legal.txt. This program comes with ABSOLUTELY NO WARRANTY.\n"
          "\n");

	//basically just inits memused if not using the custom scheme
   //the custom scheme would normally create a heap of 2 megs but
   //as it is now, the memused variable is just set to 0
	InitMemory(1024*1024*2);

	BrushHead = NULL;
	EntityHead = NULL;

	//
	// Load the specified input files
	//
	if (argc == 4)
	{
		strcpy(mapfilename, argv[1]);
		strcpy(t3dfilename, argv[2]);
		strcpy(outfilename, argv[3]);
		if (!LoadMap(mapfilename))
		{
			Abort("main","Unable to load .MAP file.");
		}
		if (!LoadT3D(t3dfilename))
		{
			printf("Unable to load .T3D texture alignment data.\n");
		}
		else
		{
			printf("Loaded texture parameters for %i surfaces from %s.\n", num_tpolys, t3dfilename);
		}
	}
	else
	{
		printf("Usage: MERGET3D <map file> <input t3d file> <output t3d file>\n");
		return 0;
	}

	//
	// Generate .T3D file
	//
	printf("Creating %s...\n", outfilename);
	if (SaveT3D(outfilename))
	{
		printf("Used texture parameters from %i surfaces of %s.\n", num_tused, t3dfilename);
		printf("Parameters for %i surfaces were lost.\n", num_tpolys - num_tused);
	}
	else
	{
		printf("Error writing %s.\n", outfilename);
	}

	CloseMemory();

   return 0;
}

