/*
error.c file of the MergeT3D Source Code

Copyright 1997, 1998 Alexander Malmberg
Copyright Gyro Gearloose
Copyright 1996, Trey Harrison and Chris Carollo

This program is distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "error.h"

void HandleError(char *proc,char *format, ...)
{
   char error[1024];
   va_list args;

   va_start(args,format);
   vsprintf(error,format,args);
   va_end(args);

   fprintf(stderr, "-- %s:  %s\n", proc, error);
}

void Abort(char *proc,char *format, ...)
{
   char error[1024];
   va_list args;

   va_start(args,format);
   vsprintf(error,format,args);
   va_end(args);

   fprintf(stderr, "-- %s:  %s\n", proc, error);
   fprintf(stderr, "Unrecoverable error! Program terminated!\n");

   exit(1);
}

