#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <go32.h>
#include <sys/nearptr.h>
#include <sys/farptr.h>

#include "vga.h"

unsigned char screen[64000];

void UpdateScreen(void)
{
   dosmemput(screen,320*200,0xa0000);
}

void InitVGA(void)
{
/*   if (!__djgpp_nearptr_enable())
   {
      printf("Error! Unable to initialize graphics system!\n");
      exit(1);
   }*/
}

void SetMode(int m)
{
   asm volatile
   ("
      movl %0,%%eax
      intb $0x10
   "
   :
   : "g" (m)
   : "%eax" );
}

void ClrVGA(void)
{
   asm volatile
   ("
      movl %0,%%edi
      xorl %%eax,%%eax
      movl $16000,%%ecx
      rep
      stosl
   "
   :
   : "g" (&screen)
   : "%eax","%ecx","%edi");
}

void Line(int x1,int y1,int x2,int y2,int arg_c)
{
   int dx,dy;
   unsigned char *s;
   int c=arg_c;

   if (x1==x2)
   {
      if ((x1<0) || (x1>319)) return;
      if ((y1<0) && (y2<0)) return;
      if ((y1>199) && (y2>199)) return;

      if (y1<0) y1=0;
      if (y2>199) y2=199;
      if (y2<0) y2=0;
      if (y1>199) y1=199;

      s=&screen[x1+y1*320];
      if (y1<y2)
      {
         for (;y1<=y2;y1++)
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("x1==x2 screen[%i]=%i\n",s-screen,c);
            *s=c;
            s+=320;
         }
      }
      else
      {
         for (;y1>=y2;y1--)
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("x1==x2 screen[%i]=%i\n",s-screen,c);
            *s=c;
            s-=320;
         }
      }

      return;
   }

   if (y1==y2)
   {
      if ((y1<0) || (y1>199)) return;
      if ((x1<0) && (x2<0)) return;
      if ((x1>319) && (x2>319)) return;

      if (x1<0) x1=0;
      if (x2>319) x2=319;
      if (x2<0) x2=0;
      if (x1>319) x1=319;

      s=&screen[x1+y1*320];

      if (x1<x2)
      {
         for (;x1<=x2;x1++)
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("y1==y2 screen[%i]=%i\n",s-screen,c);
            *s++=c;
         }
      }
      else
      {
         for (;x1>=x2;x1--)
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("y1==y2 screen[%i]=%i\n",s-screen,c);
            *s--=c;
         }
      }
      return;
   }

   dx=abs(x2-x1);
   dy=abs(y2-y1);

   if (dx>dy)
   {
      int rx=0;

      if (x2<x1)
      {
         int t=x1;
   
         x1=x2;
         x2=t;
   
         t=y1;
         y1=y2;
         y2=t;
      }

      dx=x2-x1;
      dy=y2-y1;
   
      s=&screen[x1+y1*320];

      for (;x1<=x2;x1++)
      {
         if ((x1>=0) && (x1<=319) && (y1>=0) && (y1<=199))
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("dx>dy screen[%i]=%i\n",s-screen,c);
            *s=c;
         }
         s++;

         rx+=dy;

         if (rx>dx)
         {
            s+=320;
            y1++;
            rx-=dx;
         }

         if (rx<0)
         {
            s-=320;
            y1--;
            rx+=dx;
         }
      }

      return;
   }
   else
   {
      int ry=0;

      if (y2<y1)
      {
         int t=x1;
   
         x1=x2;
         x2=t;
   
         t=y1;
         y1=y2;
         y2=t;
      }
   
      dx=x2-x1;
      dy=y2-y1;
   
      s=&screen[x1+y1*320];

      for (;y1<=y2;y1++)
      {
         if ((x1>=0) && (x1<=319) && (y1>=0) && (y1<=199))
         {
//            if (((s-screen)<0) || ((s-screen)>63999)) printf("dx<dy screen[%i]=%i\n",s-screen,c);
            *s=c;
         }
         s+=320;

         ry+=dx;

         if (ry>dy)
         {
            s++;
            x1++;
            ry-=dy;
         }

         if (ry<0)
         {
            s--;
            x1--;
            ry+=dy;
         }
      }

      return;
   }
}

void WaitVBL(void)
{
   unsigned char temp;

   do
   {
      asm volatile("
         movl $0x3da,%%edx
         inb %%dx,%%al
         movb %%al,%0
         "
         : "=g" (temp)
         :
         : "%eax","%edx");
   } while ((temp&8));

   do
   {
      asm volatile("
         movl $0x3da,%%edx
         inb %%dx,%%al
         movb %%al,%0
         "
         : "=g" (temp)
         :
         : "%eax","%edx");
   } while (!(temp&8));
}

void SetPal(unsigned char *pal)
{
   asm volatile("
      movl $0x3c8,%%edx
      xorl %%eax,%%eax
      outb %%al,%%dx

      cld
      movl %0,%%esi
      movl $0x3c9,%%edx
      movl $768,%%ecx
      rep
      outsb
      "
      :
      : "g" (pal)
      : "%eax","%ecx","%edx","%esi");
}

void GetPal(unsigned char *pal)
{
   asm volatile("
      movl $0x3c8,%%edx
      xorl %%eax,%%eax
      outb %%al,%%dx

      cld
      pushw %%ds
      popw %%es
      movl %0,%%edi
      movl $0x3c9,%%edx
      movl $768,%%ecx
      rep
      insb
      "
      :
      : "g" (pal)
      : "%eax","%ecx","%edx","%esi");
}

void Rectangle(int x1,int y1,int x2,int y2,int arg_c)
{
   register unsigned char *s;
   register int i;
   register int c=arg_c;

   if (x2<x1)
   {
      int t=x2;
      x2=x1;
      x1=t;
   }

   if (y2<y1)
   {
      int t=y2;
      y2=y1;
      y1=t;
   }

   s=&screen[x1+y1*320];

   for (i=x1;i<=x2;i++)
   {
      *s++=c;
   }

   for (i=y1;i<=y2;i++)
   {
      *s=c;
      s+=320;
   }

   for (i=x2;i>=x1;i--)
   {
      *s--=c;
   }

   for (i=y2;i>=y1;i--)
   {
      *s=c;
      s-=320;
   }
}

void Bar(int x1,int y1,int x2,int y2,int arg_c)
{
   register unsigned char *s;
   register int i,j;
   register int c=arg_c;

   if (x2<x1)
   {
      int t=x2;
      x2=x1;
      x1=t;
   }

   if (y2<y1)
   {
      int t=y2;
      y2=y1;
      y1=t;
   }

   s=&screen[x1+y1*320];

   for (i=y2-y1+1;i;i--)
   {
      for (j=x2-x1+1;j;j--)
         *s++=c;
      s+=320-x2+x1-1;
   }
}

void PutChar(int x,int y,int color,int ch)
{
   int i,j,k;
   unsigned char data[8];

   _farsetsel(_dos_ds);
   *(unsigned int *)&data[0]=_farnspeekl(0xffa6e + ch*8);
   *(unsigned int *)&data[4]=_farnspeekl(0xffa6e + ch*8+4);

   for (i=0;i<8;i++)
   {
      k=128;
      for (j=0;j<8;j++)
      {
         if (data[i]&k)
         {
            PutPixel(x+j,y+i,color);
         }
         k>>=1;
      }
   }
}

void PutString(int x,int y,int color,char *format, ...)
{
   char buf[64];
   va_list args;
   char *b;
   int i,j,k;
   unsigned char data[8];

   va_start(args,format);
   vsprintf(buf,format,args);
   va_end(args);

   b=buf;

   while (*b)
   {
      _farsetsel(_dos_ds);
      *(unsigned int *)&data[0]=_farnspeekl(0xffa6e + *b*8);
      *(unsigned int *)&data[4]=_farnspeekl(0xffa6e + *b*8+4);

      for (i=0;i<8;i++)
      {
         k=128;
         for (j=0;j<8;j++)
         {
            if (data[i]&k)
            {
               PutPixel(x+j,y+i,color);
            }
            k>>=1;
         }
      }

      x+=8;
      b++;
   }
}

typedef struct
{
   char id[4];
   int xsize;
   int ysize;
} pic_head_t;

picture_t *LoadPic(char *name)
{
   picture_t *pic;
   pic_head_t *ph;
   void *buf;
   FILE *f;
   int size;

   f=fopen(name,"rb");
   if (!f)
   {
      printf("WARNING! %s doesn't exist!\n",name);
      return NULL;
   }
   fseek(f,0,SEEK_END);
   size=ftell(f);
   buf=malloc(size);
   fseek(f,0,SEEK_SET);
   fread(buf,1,size,f);
   fclose(f);
   ph=buf;

   if ((ph->id[0]!='P') ||
       (ph->id[1]!='I') ||
       (ph->id[2]!='C'))
   {
      printf("Invalid picture!");
      exit(1);
   }
   switch (ph->id[3])
   {
   case 0:
      {
         int plen=ph->xsize*ph->ysize;
         pic=(picture_t *)malloc(plen+8);
         pic->xsize=ph->xsize;
         pic->ysize=ph->ysize;
         memcpy(pic->data,(buf+sizeof(pic_head_t)),plen);
      }
      break;
   case 1:
      {
         int clen;
         unsigned char *b,*bend;
         unsigned char *d;
         int i,len;

         pic=(picture_t *)malloc(ph->xsize*ph->ysize+8);
         if (!pic)
         {
            printf("Out of memory!");
            exit(1);
         }
         pic->xsize=ph->xsize;
         pic->ysize=ph->ysize;

         clen=*(int *)(buf+sizeof(pic_head_t));

         b=bend=buf+sizeof(pic_head_t)+4;
         bend+=clen;

         d=pic->data;

         while (b<bend)
         {
            if ((*b&0xc0)==0xc0)
            {
               len=(*b&0x3f)+1;
               b++;
               for (i=0;i<len;i++)
                  *d++=*b;
               b++;
            }
            else
            {
               *d++=*b++;
            }
         }
      }
      break;
   default:
      printf("Unknown picture type!");
      exit(1);
      break;
   }
   free(buf);
   return pic;
}

void PutImage(int x,int y,picture_t *p)
{
   unsigned int *s,*d;
   int i,j;

   s=(unsigned int *)&p->data;
   d=(unsigned int *)&screen[x+y*320];
   for (i=p->ysize;i;i--)
   {
      for (j=p->xsize/4;j;j--)
      {
         *d++=*s++;
      }
      (int)d+=320-p->xsize;
   }
}

void PutImageT(int x,int y,picture_t *p)
{
   unsigned char *s,*d;
   int i,j;

   s=(unsigned char *)&p->data;
   d=(unsigned char *)&screen[x+y*320];
   for (i=p->ysize;i;i--)
   {
      for (j=p->xsize;j;j--)
      {
         if (*s!=0xff) *d=*s;
         d++;
         s++;
      }
      d+=320-p->xsize;
   }
}

