#ifndef LEVEL_H
#define LEVEL_H

typedef struct
{
   short p[2];
   short angle;
   short type;
   short flags;
} thing_t;

typedef struct
{
   short v[2];
   short flags;
   short type;
   short tag;
   short sidedef[2];
} linedef_t;

typedef struct
{
   short ofs[2];
   char upper[8];
   char lower[8];
   char middle[8];
   short sector;
} sidedef_t;

typedef short vertex_t[2];

typedef struct
{
   short v[2];
   short angle;
   short linedef;
   short dir;
   short dist;
} seg_t;

typedef struct
{
   short num;
   short start;
} ssector_t;

typedef struct
{
   short p[2] __attribute__ ((packed));
   short dp[2] __attribute__ ((packed));

   short bound[8] __attribute__ ((packed));

   short child[2] __attribute__ ((packed));
} node_t;

typedef struct
{
   short fh;
   short ch;
   char ftex[8];
   char ctex[8];
   short light;
   short type;
   short tag;
} sector_t;

extern thing_t *things;
extern linedef_t *linedefs;
extern sidedef_t *sidedefs;
extern int *sd_flag;
extern int *sd_added;  // 1 = lower  2 = upper  4 = middle
extern vertex_t *verts;
extern seg_t *segs;
extern ssector_t *ssectors;
extern node_t *nodes;
extern sector_t *sectors;

extern int n_things;
extern int n_linedefs;
extern int n_sidedefs;
extern int n_verts;
extern int n_segs;
extern int n_ssectors;
extern int n_nodes;
extern int n_sectors;

sector_t *InSector(int x,int y);

void LoadLevel(char *lump);

void InitBSP();

void Recenter(void);

#endif

