/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <pc.h>
#include <bios.h>
#include <sys/stat.h>

#include "error.h"
#include "wad.h"

//#define DRAW

unsigned char *dpal;
unsigned char qpal[768];

int ar,ag,ab;

int Dith(int r,int g,int b)
{
   int best;
   int bestval;
   int i;
   int val;
   int dr,dg,db;

   r-=ar;
   if (r>255) r=255;
   if (r<0) r=0;

   g-=ag;
   if (g>255) g=255;
   if (g<0) g=0;

   b-=ab;
   if (b>255) b=255;
   if (b<0) b=0;

   best=0;
   bestval=r*r+g*g+b*b;

   for (i=1;i<255;i++)
   {
      if (!bestval)
         break;

      dr=qpal[i*3+0]-r;
      dg=qpal[i*3+1]-g;
      db=qpal[i*3+2]-b;

      val=dr*dr+dg*dg+db*db;

      if (val<bestval)
      {
         best=i;
         bestval=val;
      }
   }

   ar=(qpal[best*3+0]-r);
   ag=(qpal[best*3+1]-g);
   ab=(qpal[best*3+2]-b);

/*   printf("(%i %i %i) dithered to %i (%i %i %i)\n",
      r,g,b,
      best,
      qpal[best*3+0],
      qpal[best*3+1],
      qpal[best*3+2]);*/

   return best;
}

#define	MIPLEVELS	4
typedef struct miptex_s
{
	char		name[32];
	unsigned	width, height;
	unsigned	offsets[MIPLEVELS];		// four mip maps stored
	char		animname[32];			// next frame in animation chain
	int			flags;
	int			contents;
	int			value;
} miptex_t;

void WriteWal(char *name,unsigned char *otex,int xs,int ys)
{
#ifdef DRAW
   int k;
static unsigned char screen[10*64000];
#endif

   FILE *f;
   miptex_t mh;
   char fname[256];
   int *mip[4];

   int x,y;
   int i;

   int r,g,b;

   int sh;

   unsigned char *buf;

   unsigned char *tex;
   int ft;

   if (xs%16)
   {
      tex=malloc(xs*ys*2);
      if (!tex)
         Error("Out of memory!");
      ft=1;

      for (i=0;i<ys;i++)
      {
         memcpy(&tex[(i+ 0)*xs*2+ 0],&otex[i*xs],xs);
         memcpy(&tex[(i+ 0)*xs*2+xs],&otex[i*xs],xs);
      }

      xs*=2;
   }
   else
   {
      tex=otex;
      ft=0;
   }

   if (ys%16)
   {
      if (ft)
         otex=tex;

      tex=malloc(xs*ys*2);
      if (!tex)
         Error("Out of memory!");

      for (i=0;i<ys;i++)
      {
         memcpy(&tex[(i+ 0)*xs],&otex[i*xs],xs);

         memcpy(&tex[(i+ys)*xs],&otex[i*xs],xs);
      }

      ys*=2;

      if (ft)
         free(otex);

      ft=1;
   }

   strcpy(fname,"doom/");
   strcat(fname,name);
   strcat(fname,".wal");

   strlwr(fname);

   f=fopen(fname,"wb");
   if (!f)
      Error("Couldn't create '%s'!",fname);

   strcpy(mh.name,"doom/");
   strcat(mh.name,name);
   strlwr(mh.name);
   mh.width=xs;
   mh.height=ys;
   mh.animname[0]=0;
   mh.flags=mh.contents=mh.value=0;

   mh.offsets[0]=sizeof(mh);
   mh.offsets[1]=mh.offsets[0]+(xs*ys>>2);
   mh.offsets[2]=mh.offsets[1]+(xs*ys>>4);
   mh.offsets[3]=mh.offsets[2]+(xs*ys>>6);

   fwrite(&mh,1,sizeof(mh),f);

   for (i=0;i<4;i++)
   {
      mip[i]=malloc(4*3*(xs*ys)>>(i*2));
      if (!mip[i])
         Error("Out of memory!");
      memset(mip[i],0,4*3*(xs*ys)>>(i*2));
   }

   for (y=0;y<ys;y++)
   {
      for (x=0;x<xs;x++)
      {
         r=dpal[tex[y*xs+x]*3+0];
         g=dpal[tex[y*xs+x]*3+1];
         b=dpal[tex[y*xs+x]*3+2];
         for (i=0;i<4;i++)
         {
            mip[i][((x>>i)+(y>>i)*(xs>>i))*3+0]+=r;
            mip[i][((x>>i)+(y>>i)*(xs>>i))*3+1]+=g;
            mip[i][((x>>i)+(y>>i)*(xs>>i))*3+2]+=b;
         }
      }
   }

   buf=malloc(xs*ys);
   if (!buf)
      Error("Out of memory!");

   for (i=0;i<4;i++)
   {
      sh=i*2;

      for (y=0;y<ys>>i;y++)
      {
         ar=ag=ab=0;
         for (x=0;x<xs>>i;x++)
         {
            r=mip[i][(x+y*(xs>>i))*3+0];
            g=mip[i][(x+y*(xs>>i))*3+1];
            b=mip[i][(x+y*(xs>>i))*3+2];

            r>>=sh;
            g>>=sh;
            b>>=sh;

            buf[y*(xs>>i)+x]=Dith(r,g,b);
         }
      }

      fwrite(buf,1,(xs*ys)>>sh,f);

#ifdef DRAW
      memset(screen,0,sizeof(screen));
      for (k=0;k<ys>>i;k++)
      {
         memcpy(&screen[320*k],&buf[k*(xs>>i)],xs>>i);
      }

      dosmemput(screen,64000,0xa0000);
      bioskey(0);
#endif

      free(mip[i]);
   }

   free(buf);

   if (ft)
      free(tex);

   fclose(f);
}

void **pnames;
int n_pnames;

void LoadPNames(void)
{
   void *temp;
   int i;
   char name[64];
   int tsize,size;

   temp=LoadLump(FindLump("PNAMES"),NULL);
   n_pnames=*(int *)temp;
   printf("LoadPNames(): %i pnames, ",n_pnames);
   fflush(stdout);

   pnames=malloc(sizeof(void *)*n_pnames);
   if (!pnames)
      Error("Out of memory!");

   tsize=0;
   for (i=0;i<n_pnames;i++)
   {
      strncpy(name,&((unsigned char *)(temp))[i*8+4],8);
      name[8]=0;
      pnames[i]=LoadLump(FindLump(name),&size);
      tsize+=size;
   }

   free(temp);
   printf("%i bytes\n",tsize);
}

typedef struct
{
   short x __attribute__ ((packed));
   short y __attribute__ ((packed));
   short pname __attribute__ ((packed));
   short u[2] __attribute__ ((packed));
} patch_t;

typedef struct
{
   char name[8] __attribute__ ((packed));
   short u1[2] __attribute__ ((packed));
   short xs __attribute__ ((packed));
   short ys __attribute__ ((packed));
   short u2[2] __attribute__ ((packed));
   short n_patches __attribute__ ((packed));
   patch_t patches[0] __attribute__ ((packed));
} texture_t;

void AddPatch(int npatch,int xo,int yo,unsigned char *tex,int txs,int tys)
{
   unsigned char *patch;
   unsigned char *p;
   unsigned char *d;
   unsigned int *ofs;

   int i,j;
   int y;

   int xs,ys;

   patch=(unsigned char *)pnames[npatch];

   xs=*(short *)patch;
   ys=*(short *)(patch+2);

   ofs=(unsigned int *)patch;
   ofs+=2;
   for (i=0;i<xs;i++)
   {
      p=&patch[*ofs++];
      if (i+xo<0)
         continue;

      if (i+xo>=txs)
         break;

      while (*p!=0xff)
      {
         y=*p++;
         j=*p++;
         p++;

         ys=y+yo;

         d=&tex[ys*txs+i+xo];

         for (;j;j--)
         {
            if ((ys>=0) && (ys<tys))
               *d=*p;

            d+=txs;
            p++;
            ys++;
         }
         p++;
      }
   }
}

void AddTex(char *lname)
{
   void *ltex;
   int num;
   texture_t *dt;
   int i,j;
   int *ofs;

   unsigned char *tex;
   int xs,ys;
   patch_t *p;


   ltex=LoadLump(FindLump(lname),NULL);
   num=*(int *)ltex;
   printf("AddTex(\"%s\"): %i textures\n",lname,num);
   ofs=ltex;
   ofs++;

   for (i=0;i<num;i++)
   {
      dt=(texture_t *)&((unsigned char *)ltex)[*ofs];
      dt->u1[0]=0;
      ofs++;

      printf("%8s: %ix%i %i\n",dt->name,dt->xs,dt->ys,dt->n_patches);

      xs=dt->xs;

/*      if (!(xs%16) && (i>5))
         continue;*/

      ys=dt->ys;
      tex=malloc(xs*ys);
      if (!tex)
         Error("Out of memory!");
      memset(tex,0,xs*ys);

      for (j=0;j<dt->n_patches;j++)
      {
         p=&dt->patches[j];

         AddPatch(p->pname,p->x,p->y,tex,xs,ys);
      }

//      WriteWal(dt->name,tex,xs,ys);

      free(tex);
   }

   free(ltex);
}

void AddFlats(void)
{
   int start,end;
   int i;
   unsigned char *tex;
   char name[128];

   start=FindLump("F_START");
   end=FindLump("F_END");
   printf("AddFlats(): %i potential flats\n",end-start);

   for (i=start;i<end;i++)
   {
      if (lumps[i].size!=4096)
         continue;

      strncpy(name,lumps[i].name,8);
      name[8]=0;

      printf("%8s: 64x64\n",name);

      tex=LoadLump(i,NULL);
//      WriteWal(name,tex,64,64);
   }
}

int main(int argc, char **argv)
{
   printf(
      "d2tex version 1.0 (" __DATE__ ")\n"
      "---------------------------------\n"
      "Copyright 1998, 1998\n"
      "  Alexander Malmberg <alexander@malmberg.org>\n"
      "\n"
      "Distributed under the GNU General Public License.\n"
      "See legal.txt for more information.\n"
      "\n"
      );

   if (argc!=2)
   {
      printf(
         "Syntax:\n"
         "  d2tex wadfile.wad\n"
         "\n"
         "  Will extract all textures from wadfile.wad to doom/xyz.wal\n"
         "\n"
         );
      exit(1);
   }

   mkdir("doom",0);

   InitWad(argv[1]);

   LoadPNames();

   {
      FILE *f;
      int i;

      dpal=LoadLump(FindLump("PLAYPAL"),NULL);
      for (i=0;i<768;i++)
         dpal[i]=(unsigned char)(((float)dpal[i])*0.8);

      f=fopen("q2.pal","rb");
      if (!f)
         Error("Couldn't load 'q2.pal'!");
      fread(qpal,1,768,f);
      fclose(f);
   }

#ifdef DRAW
   asm volatile
   ("
      movl $0x13,%%eax
      intb $0x10
   "
   :
   :
   : "%eax" );


   {
      int i;
      unsigned char *qp=qpal;

      outportb(0x3C8,0);
      for (i=768;i;i--)
      {
         outportb(0x3C9,*qp++ >>2);
      }
   }
#endif

   AddFlats();

   AddTex("TEXTURE1");
   AddTex("TEXTURE2");

#ifdef DRAW
   asm volatile
   ("
      movl $0x03,%%eax
      intb $0x10
   "
   :
   :
   : "%eax" );
#endif

   return 0;
}

