/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QOOLE_ID_H
#define QOOLE_ID_H

// MAXUTILS can't > 32
#define MAXUTILS 5

enum QooleID
{
	QID_MAIN_FRAME = wxID_HIGHEST+1,
	QID_DOCUMENTS_VIEW,
	QID_LEFT_NOTEBOOK,

	// Process window.
	QID_PROCESS_WINDOW,
	QID_PROCESS,

	// Texture view.
	QID_TEXTURE_VIEW,
	QID_TEXLIST_CHOICE,
	QID_TEXSIZE_CHOICE,
	QID_TEXWINDOW_APPLY,

	// Tree view.
	QID_TREE_VIEW,

	// Property sheet.
	QID_PROPSHEET_NOTEBOOK,
	QID_PROP_LIGHT_COLOR,
	QID_PROP_ENTKEYS,

	// Texture Properties.
	QID_PROPTEX_OFFSET_X_POS,
	QID_PROPTEX_OFFSET_X_NEG,
	QID_PROPTEX_OFFSET_Y_POS,
	QID_PROPTEX_OFFSET_Y_NEG,
	QID_PROPTEX_SCALE_X_POS,
	QID_PROPTEX_SCALE_X_NEG,
	QID_PROPTEX_SCALE_Y_POS,
	QID_PROPTEX_SCALE_Y_NEG,
	QID_PROPTEX_ROT_POS,
	QID_PROPTEX_ROT_NEG,
	QID_PROPTEX_OFFSET_X,
	QID_PROPTEX_OFFSET_Y,
	QID_PROPTEX_SCALE_X,
	QID_PROPTEX_SCALE_Y,
	QID_PROPTEX_ROT,
	QID_PROPTEX_LOCK,
	QID_PROPTEX_SELECT_ALL_FACES,
	QID_PROPTEX_SELECT_FACE,
	QID_PROPTEX_PREV_FACE,
	QID_PROPTEX_NEXT_FACE,
	QID_PROPTEX_AUTO_ALIGN,
	QID_PROPTEX_RESET,

	// View type
	QID_VIEW_RENDER_WIREFRAME,

	// View timers.
	QID_VIEW_TIMER_UPDATEDRAGSEL,
	QID_VIEW_TIMER_SCROLLVIEW,
	QID_VIEW_TIMER_RENDERQVIEWS,
	QID_VIEW_TIMER_RENDERLOCKEDQVIEWS,
	QID_VIEW_TIMER_UPDATE,

	// Compile dialog.
	QID_COMPILE_CURRENT_UTIL,
	QID_COMPILE_UTIL_PARAMS,
	QID_COMPILE_USE_UTIL_START,
	QID_COMPILE_USE_UTIL_END = QID_COMPILE_USE_UTIL_START + MAXUTILS,

	// Popup menus.
	QID_MENUENTRY_START,
	QID_MENUENTRY_END = QID_MENUENTRY_START + 1000,
};

#endif //QOOLE_ID_H
