/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef PROGRESSWINDOW_H
#define PROGRESSWINDOW_H

class ProgressWindow: public wxFrame
{
public:
	ProgressWindow(wxWindow *parent, const wxString &title, const wxString &caption,
			wxPoint position = wxDefaultPosition);
	~ProgressWindow();

	bool Cancelled() const;

	int GetProgress();
	void GetRange(int &min, int &max);

	void SetProgress(int position);
	void SetRange(int min, int max);

	// Events
	void OnCancel(wxCommandEvent &event);
	void OnCloseWindow(wxCloseEvent& event);
	DECLARE_EVENT_TABLE();

private:
	wxGauge *progress;
	bool isCancelled;
	int progressPosition;
	int min, max;
};

class ProgressFunc
{
public:
	ProgressFunc(const wxString &title, const wxString &caption);
	~ProgressFunc();

	static bool SetPos(int percent);

private:
	static ProgressWindow *progressWindow;
};


#endif //PROGRESSWINDOW_H
