/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QTREEVIEW_H
#define QTREEVIEW_H

#include "QooleView.h"
#include "Objects.h"

#define DUTV_RENAMEOBJ		0x1000

class QooleDoc;
class QTreeItem;
class QTreeView: public wxTreeCtrl, public QooleView
{
public:
	QTreeView(wxWindow *parent);
	~QTreeView();

	void AddDocument(QooleDoc *document);
	void RemoveDocument(QooleDoc *document);
	void SetCurrentDocument(QooleDoc *document);

	void OnUpdate(wxView* sender, wxObject* hint = NULL);

	DECLARE_EVENT_TABLE();
private:
	void OnTreeExpanding(wxTreeEvent &ev);
	void OnTreeCollapsing(wxTreeEvent &ev);

	void DeleteAllChildren(wxTreeItemId node);
	void ExpandSubTree(wxTreeItemId node);
	void CollapseSubTree(wxTreeItemId node);
	void SortSubTree(wxTreeItemId node);
	wxTreeItemId ExpandObjectTree(const Object *object);
	void RefreshSubTree(wxTreeItemId node);
	wxTreeItemId AddItemNode(wxTreeItemId parentNode, Object *object);

	wxTreeItemId FindVisibleItem(const Object *object);
	void UpdateSelection(wxTreeItemId item);
	void UpdateScopeView(Object *oldScope);

	wxTreeItemId rootItem;
	typedef std::map<QooleDoc*, QTreeItem*> DocumentItems;
	DocumentItems documentItems;

	QooleDoc *currentDocument;
	bool inUpdateView;
};

#endif //QTREEVIEW_H
