/*
Copyright (C) 1996-1997 GX Media, Inc.
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QTEXTUREVIEW_H
#define QTEXTUREVIEW_H

#include "Texture.h"
#include "QTexturePanel.h"
#include "QooleView.h"

class QTextureCell
{
public:
	QTextureCell(Texture *texture);
	~QTextureCell();

	void CreateBitmap();
	void Draw(wxDC &dc);

	Texture *texture;
	int columnId, rowId;
	int x, y;
	int width, height;
	int cellSize;
	bool selected;
	bool isFocused;
	wxBitmap bitmap;
	wxMemoryDC bitdc;
};

class QTextureWindow: public wxScrolledWindow
{
public:
	QTextureWindow(wxWindow *parent);
	~QTextureWindow();

	void SetTexList(TexList *texList);
	void SetCellSize(int size);

	int cellWidth, cellHeight;
	int cellTexSize;

	Texture *GetSelTexture(void);

	void OnSize(wxSizeEvent& event);
	void OnScroll(wxScrollEvent& event);
	void OnLButtonDown(wxMouseEvent &event);
	void OnLButtonDClick(wxMouseEvent &event);
	void OnRButtonUp(wxMouseEvent &event);
	void OnTextureApply(wxCommandEvent &event);
	virtual void OnDraw(wxDC& dc);
	DECLARE_EVENT_TABLE();

private:
	static const int TableBorder = 5;
	static const int CellTextHeight = 15;
	void CalcTexCells();
	void SelectTexture(const wxPoint &point);

	TexList *texList;
	std::vector<QTextureCell*> cells;
	QTextureCell *selectedCell;

	int columns, rows;

};

class QTextureCurrent: public QTexturePanel, public QooleView
{
public:
	QTextureCurrent(wxWindow *parent);
	~QTextureCurrent();

	virtual void OnUpdate(wxView* sender, wxObject* hint = NULL);
	DECLARE_EVENT_TABLE();

private:
	void OnPaint(wxPaintEvent &event);
};

class QTextureView: public wxPanel
{
public:
	QTextureView(wxWindow *parent);
	~QTextureView();

	Texture *GetSelTexture(void);

	void OnNewContents(void);

	DECLARE_EVENT_TABLE();

private:
	void BuildChoices();
	void OnListChoice(wxCommandEvent& event);
	void OnSizeChoice(wxCommandEvent& event);
	void OnShow(wxShowEvent& event);

	QTextureCurrent *currentTextureView;
	QTextureWindow *textureWindow;
	wxChoice *listChoice;
	wxChoice *sizeChoice;
	bool buildLater;

	std::vector<wxString> texFiles;
};

#endif //QTEXVIEW_H
