/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QTEXTUREPANEL_H
#define QTEXTUREPANEL_H

#include "LCommon.h"

class Texture;
class QTexturePanel: public wxPanel
{
public:
	QTexturePanel(wxWindow *parent, int id = wxID_ANY,
			wxPoint position = wxDefaultPosition,
			wxSize = wxDefaultSize);
	~QTexturePanel();

	Texture *GetTexture() const;
	void SetTexture(Texture *texture);

	void OnPaint(wxPaintEvent &event);
	void OnSize(wxSizeEvent &event);
	DECLARE_EVENT_TABLE();

protected:
	void RecreateImage();

	bool invalid;
	Texture *texture;
	LPalette pal;
	wxBitmap bitmap;
	wxMemoryDC memDC;
};

#endif //QTEXTUREPANEL_H
