/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QPROPTEXTURE_H
#define QPROPTEXTURE_H

#include "QooleView.h"
#include "QPropSheetPage.h"

class QTexturePanel;
class QView;
class QPropTexture: public QPropSheetPage, public QooleView
{
public:
	QPropTexture(wxWindow *parent);
	~QPropTexture();

	virtual bool TransferDataToWindow();

	virtual void OnUpdate(wxView* sender, wxObject* hint = NULL);
	virtual void OnActivate(wxActivateEvent &event);
	void OnXOffsetIncr(wxCommandEvent &event);
	void OnXOffsetDecr(wxCommandEvent &event);
	void OnYOffsetIncr(wxCommandEvent &event);
	void OnYOffsetDecr(wxCommandEvent &event);
	void OnXScaleIncr(wxCommandEvent &event);
	void OnXScaleDecr(wxCommandEvent &event);
	void OnYScaleIncr(wxCommandEvent &event);
	void OnYScaleDecr(wxCommandEvent &event);
	void OnRotIncr(wxCommandEvent &event);
	void OnRotDecr(wxCommandEvent &event);

	void OnEditChanged(wxCommandEvent &event);

	void OnOptionSelectAll(wxCommandEvent &event);
	void OnOptionSelectFace(wxCommandEvent &event);
	void OnSelectPrevFace(wxCommandEvent &event);
	void OnSelectNextFace(wxCommandEvent &event);

	void OnReset(wxCommandEvent &event);
	void OnAutoAlign(wxCommandEvent &event);
	DECLARE_EVENT_TABLE();
private:
	QView *Get3DView();

	void DisableControls();

	void RenderSelectedFace(bool visible);

	void OnSelectNewFace();

	void UpdateDoc(bool updateViews = true);
	void CommitAttributes();

	void AutoAlignFace(int faceIndex, float &xoff, float &yoff,
			float &rotAng, float &xScl, float &yScl);
	void AutoAlignBrush();

	void ResetTextureFace();
	void ResetTextureBrushFaces();

	QTexturePanel *textureControl;
	wxRadioButton *selectAllButton;
	wxRadioButton *selectFaceButton;
	wxButton *prevFaceButton;
	wxButton *nextFaceButton;
	wxButton *autoAlignButton;
	wxButton *resetButton;
	wxButton *rotDecButton;
	wxButton *rotIncrButton;
	wxPanel *offsetArrows;
	wxPanel *scaleArrows;
	wxCheckBox *texLockCheck;
	wxTextCtrl *xoffsetCtrl;
	wxTextCtrl *yoffsetCtrl;
	wxTextCtrl *xscaleCtrl;
	wxTextCtrl *yscaleCtrl;
	wxTextCtrl *rotAngCtrl;
	wxWindow *focusedControl;

	float xoffset, oldXOffset;
	float yoffset, oldYOffset;
	float xscale, oldXScale;
	float yscale, oldYScale;
	float rotAng, oldRotAng;
	bool active;
	bool selectAll, selectFace;
	bool controlsEnabled;
	bool transferring;
};

#endif //QPROPTEXTURE_H
