#include "stdafx.h"
#include "QConfGeneral.h"

BEGIN_EVENT_TABLE(QConfGeneral, wxPanel)
END_EVENT_TABLE()

QConfGeneral::QConfGeneral(wxWindow *parent)
	: wxPanel(parent)
{
	// Create the sheet layout.
	wxBoxSizer *panelSizer = new wxBoxSizer(wxVERTICAL);

	// Create the panel top part
	wxFlexGridSizer *topSizer = new wxFlexGridSizer(2, 2);
	panelSizer->Add(topSizer, 0, wxEXPAND|wxALL, 5);

	wxStaticText *label = new wxStaticText(this, wxID_ANY,
			_("Undo/Redo levels:"));
	wxTextCtrl *undoLevels = new wxTextCtrl(this, wxID_ANY);
	topSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	topSizer->Add(undoLevels, 0, wxEXPAND);

	label = new wxStaticText(this, wxID_ANY,
			_("Default hollow wall width:"));
	wxTextCtrl *hollowWidth = new wxTextCtrl(this, wxID_ANY);
	topSizer->Add(label, 0, wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL);
	topSizer->Add(hollowWidth, 0, wxEXPAND);

	// Create the bottom part.
	wxCheckBox *hollowPrompt = new wxCheckBox(this, wxID_ANY,
			_("Ask for hollow width everytime"));
	wxCheckBox *groupPrompt = new wxCheckBox(this, wxID_ANY,
			_("Prompt for name grouping"));
	panelSizer->Add(hollowPrompt, 0, wxEXPAND);
	panelSizer->Add(groupPrompt, 0, wxEXPAND);

	SetSizer(panelSizer);
	panelSizer->Fit(this);
}

QConfGeneral::~QConfGeneral()
{
}
