#include "stdafx.h"
#include "QConfGames.h"

BEGIN_EVENT_TABLE(QConfGames, wxPanel)
END_EVENT_TABLE()

QConfGames::QConfGames(wxWindow *parent)
	: wxPanel(parent)
{
	// Create the layout.
	wxBoxSizer *panelSizer = new wxBoxSizer(wxVERTICAL);

	// Game selection.
	wxBoxSizer *gameSizer = new wxBoxSizer(wxHORIZONTAL);
	panelSizer->Add(gameSizer, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

	wxStaticText *label = new wxStaticText(this, wxID_ANY, _("Game"));
	wxChoice *gameChoice = new wxChoice(this, wxID_ANY);
	gameSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL|wxRIGHT, 5);
	gameSizer->Add(gameChoice);

	// Map compile.
	wxStaticBoxSizer *mapBox = new wxStaticBoxSizer(wxVERTICAL, this,
			_("Map Compile Utilities"));
	panelSizer->Add(mapBox, 0, wxEXPAND|wxALL, 5);

	wxFlexGridSizer *mapSizer = new wxFlexGridSizer(3, 2);
	mapSizer->AddGrowableCol(1, 1);
	mapBox->Add(mapSizer, 0, wxEXPAND);

	// Program choice
	label = new wxStaticText(this, wxID_ANY, _("Program"));
	wxChoice *utilChoice = new wxChoice(this, wxID_ANY);
	mapSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	mapSizer->Add(utilChoice, 0, wxEXPAND);
	mapSizer->AddStretchSpacer(0);

	// Program path.
	label = new wxStaticText(this, wxID_ANY, _("Path"));
	wxTextCtrl *utilPath = new wxTextCtrl(this, wxID_ANY);
	wxButton *utilBrowse = new wxButton(this, wxID_ANY, _("Browse"));
	mapSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	mapSizer->Add(utilPath, 0, wxEXPAND);
	mapSizer->Add(utilBrowse);

	// Game path
	wxStaticBox *gameBox = new wxStaticBox(this, wxID_ANY, _("Game"));
	wxStaticBoxSizer *gameBoxSizer = new wxStaticBoxSizer(gameBox, wxHORIZONTAL);
	panelSizer->Add(gameBoxSizer, 0, wxEXPAND|wxALL, 5);

	label = new wxStaticText(this, wxID_ANY, _("Path"));
	wxTextCtrl *gamePath = new wxTextCtrl(this, wxID_ANY);
	wxButton *gameBrowse = new wxButton(this, wxID_ANY, _("Browse"));
	gameBoxSizer->Add(label, 0, wxALIGN_CENTER_VERTICAL);
	gameBoxSizer->Add(gamePath, 1, wxEXPAND);
	gameBoxSizer->Add(gameBrowse);

	// Set the sizer.
	SetSizer(panelSizer);
	panelSizer->Fit(this);
}

QConfGames::~QConfGames()
{
}
