/*
Copyright (C) 2011 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef QCHILD_FRAME_H
#define QCHILD_FRAME_H

class QChildFrame: public wxPanel
{
	DECLARE_DYNAMIC_CLASS(QChildFrame);
public:
	QChildFrame();
	QChildFrame(wxAuiNotebook *parent, wxWindowID id, const wxString &title = wxEmptyString);
	~QChildFrame();
	
	void Create(wxAuiNotebook *parent, wxWindowID id, const wxString &title = wxEmptyString);
	
	void SetTitle(const wxString &title);
	const wxString &GetTitle() const;
	
	DECLARE_EVENT_TABLE();
private:	
	void OnSize(wxSizeEvent &event);
	
	wxString title;
	wxAuiNotebook *notebook;
};

#endif //QCHILD_FRAME_H
