/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "QPropFile.h"
#include "QooleDoc.h"
#include "QMainFrame.h"

BEGIN_EVENT_TABLE(QPropFile, QPropSheetPage)
END_EVENT_TABLE()

QPropFile::QPropFile(wxWindow *parent)
	: QPropSheetPage(parent)
{
	wxSizer *topSizer = new wxBoxSizer(wxHORIZONTAL);
	wxSizer *headers = new wxBoxSizer(wxVERTICAL);
	wxSizer *values = new wxBoxSizer(wxVERTICAL);

	topSizer->Add(headers, 0, wxEXPAND|wxALL, 5);
	topSizer->Add(values, 1, wxEXPAND|wxALL, 5);

	// Filename
	wxStaticText *label = new wxStaticText(this, wxID_ANY, _("File Name:"));
	headers->Add(label, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	fileName = new wxTextCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition,
			wxDefaultSize, wxTE_READONLY);
	values->Add(fileName, 0, wxEXPAND);

	// Last modification time.
	label = new wxStaticText(this, wxID_ANY, _("Last Modified:"));
	headers->Add(label, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	lastModified = new wxTextCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition,
			wxDefaultSize, wxTE_READONLY);
	values->Add(lastModified, 0, wxEXPAND);

	// Game type.
	label = new wxStaticText(this, wxID_ANY, _("Game Type:"));
	headers->Add(label, 0, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	gameType = new wxTextCtrl(this, wxID_ANY, wxT(""), wxDefaultPosition,
			wxDefaultSize, wxTE_READONLY);
	values->Add(gameType, 0, wxEXPAND);

	SetSizer(topSizer);
	SetAutoLayout(true);
}

QPropFile::~QPropFile()
{
}

void QPropFile::OnUpdate(wxView* sender, wxObject* hint)
{
	QooleDoc *doc = GetMainFrame()->GetDeskTopDocument();
	if(!doc)
	{
		fileName->SetValue(wxEmptyString);
		lastModified->SetValue(wxEmptyString);
		gameType->SetValue(wxEmptyString);
	}
	else
	{
		fileName->SetValue(doc->GetFilename());
		lastModified->SetValue(wxEmptyString); // TODO: implement this.
		gameType->SetValue(doc->GetGame()->GetName());
	}
}
