//.wal -> .pcx converter by Trey Harrison
//http://crack.com/games/golgtha
//trey@crack.com

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include "file_list.h"

int extention_type=0;
extern unsigned char quake2_pal[];

char **argv;
int  argc;

void remove_extention(char *string);
void write_pcx(char *base_name,unsigned char *mip, int width,int height,char *ext);

int main(int arg_count, char **arg_strings)
{
  argc = arg_count;
  argv = arg_strings;

  FILE *f;

  char walname[32];
  char *pcx_extensions[4] = {"_1","_2","_3","_4"}; 
  int  mip_offs[4];
  int  i,width,height;
  int  mipsize;
  int  fname_num;

  unsigned char *mip=0;
  
  if (argc<2)
  {
    printf("Must specify the .wal file\n");
    exit(-1);
  }

  fname_num = 1;

  if (argc==3)
  {
    //some really lame commandline parsing
    if (!stricmp(argv[2],"-s"))
    {
      extention_type = 1;
      fname_num      = 1;
    }
    
    if (!stricmp(argv[1],"-s"))
    {
      extention_type = 1;
      fname_num      = 2;
    }
    
    if (!stricmp(argv[2],"-1"))
    {
      extention_type = 2;
      fname_num = 1;
    }
    
    if (!stricmp(argv[1],"-1"))
    {
      extention_type = 2;
      fname_num = 2;
    }
  }  

  file_name_class *file_names = FileList(argv[fname_num]);

  while (file_names)
  {
    f = fopen(file_names->name,"rb");
    if (!f)
    {
      printf("Couldnt open file: %s\n",file_names->name);
      exit(-1);
    }

    fseek(f,0,SEEK_END);
    int fsize = ftell(f);
    fseek(f,0,SEEK_SET);

    remove_extention(file_names->name);

    fread(walname,32,1,f);
  
    fread(&width,1,sizeof(int),f);
    fread(&height,1,sizeof(int),f);

    fread(&mip_offs,4,sizeof(int),f);

    int mips_size     = (width*height) + (width*height/4) +
                        (width*height/16) + (width*height/64);
    
    int expected_size = mip_offs[0] + mips_size;
    
    if ((fsize == expected_size) && (fsize >= 56+mips_size))
    {
      mipsize = width*height;      
    
      mip = new unsigned char [mipsize];
      fseek(f,mip_offs[0],SEEK_SET);
      fread(mip,mipsize,1,f);
      write_pcx(file_names->name,mip,width,height,pcx_extensions[0]);
      delete [mipsize] mip;

      if (extention_type!=2)
      {
        //write the remaining 3 mips
        for (i=1; i<4; i++)
        {
          //write the other mips
          //divide by 4 for each mip level
          mipsize = mipsize >> 2;

          mip = new unsigned char [mipsize];
          fseek(f,mip_offs[i],SEEK_SET);
          fread(mip,mipsize,1,f);
          write_pcx(file_names->name,mip,width/(1<<i),height/(1<<i),pcx_extensions[i]);
          delete [mipsize] mip;
        }
      }
    }
    else
    {
      printf("invalid .wal file: %s\n",file_names->name);
    }

    fclose(f);

    //destruct the linked list as we go through it
    file_name_class *next = file_names->next;
    delete file_names;
    file_names = next;
  }

  return 0;
}

void remove_extention(char *name)
{
  char *last_period=0;

  while (*name)
  {
    if (*name=='.')
      last_period = name;
    name++;
  }
  
  if (last_period)
    *last_period = 0;
}

void write_pcx(char *base_name,unsigned char *mip, int width,int height,char *ext)
{
  int i,j;
  short w,h,bytesperline;
  char fname[128];    
  FILE *f=0;

  switch (extention_type)
  {
  case 0:
    strcpy(fname,base_name);
    strcat(fname,ext);
    break;
  
  case 1:
    sprintf(fname,"%s_%d_%d",base_name,width,height);
    break;
  
  case 2:
    sprintf(fname,base_name);
    break;
  }

  strcat(fname,".pcx");

  f = fopen(fname,"wb");
  if (!f)
  {
    printf("Invalid destination .pcx filename, %s\n",fname);
    return;
  }

  printf("Writing .pcx file -> %s\n",fname);

  w = width-1;
  h = height-1;
  bytesperline = width;

  //hardcoded 8 bit uncompressed .pcx writer
  fputc(0x0A,f);
  fputc(0x05,f);
  fputc(0x01,f);
  fputc(0x08,f);
  fputc(0x00,f);
  fputc(0x00,f);
  fputc(0x00,f);
  fputc(0x00,f);
	
  fwrite(&w,sizeof(short),1,f);
  fwrite(&h,sizeof(short),1,f);

  fputc(0x00,f);
  fputc(0x96,f);
  fputc(0x00,f);
  fputc(0x96,f);

  for(i=0; i<48; i++)
    fputc(0x00,f);

  fputc(0x00,f);
  fputc(0x01,f);
  fwrite(&bytesperline,sizeof(short),1,f);
  fputc(0x02,f);

  for(i=0; i<59; i++)
    fputc(0x00,f);

  for(i=0; i<height; i++)
  {
    for(j=0; j<width; j++)
    {
      fputc(0xC1,f);
      fputc(mip[i*width+j],f);
    }
  }

  fputc(12,f);
	
  //write the palette
  fwrite(quake2_pal,768,1,f);
  fclose(f);
}
