// FUTILS.CPP
// Copyright  1999 Joe Riedel, Nick Randal.
// Author: Joe Riedel.
#include "stdafx.h"
#include "futils.h"
#include <io.h>

bool CFileSearch::BeginFileSearch(CString sDir, CString sFileExt, bool bRecursive)
{
	m_sDir = sDir;
	m_sFileExt = sFileExt;
	m_bFirstFind = true;
	m_bRecursive = bRecursive;
	m_pSubSearch = NULL;
	m_nHandle = _findfirst(sDir + "\\" + sFileExt, &m_fileinfo);
	if(m_nHandle == -1)
		return false;

	return true;
}

void CFileSearch::EndFileSearch()
{
	if(m_nHandle > -1)
		_findclose(m_nHandle);
}

bool CFileSearch::SetupRecursiveSearch()
{
	m_pSubSearch = new CFileSearch();
	if(m_pSubSearch->BeginFileSearch(m_sDir + "\\" + m_fileinfo.name, m_sFileExt, true))
		return true;

	KillRecursiveSearch();
	return false;
}

bool CFileSearch::GetNextRecursiveFile(CString& sFilename)
{
	m_pSubSearch->GetNextFile(sFilename);
	if(sFilename == "")
		return false;

	sFilename = CString(m_fileinfo.name) + "\\" + sFilename;
	return false;
}

bool CFileSearch::KillRecursiveSearch()
{
	delete m_pSubSearch;
	m_pSubSearch = NULL;
	return true;
}

bool CFileSearch::GetNextFile(CString& sFilename)
{
	// Doing a recursive search?
	if(m_pSubSearch)
	{
		GetNextRecursiveFile(sFilename);
		if(sFilename == "")
		{
			KillRecursiveSearch();
			return GetNextFile(sFilename);
		}

		return false;
	}

	if(m_bFirstFind)
	{
		m_bFirstFind = false;
		sFilename = m_fileinfo.name;
		if(sFilename == ".." || sFilename == ".")
			return GetNextFile(sFilename);
		
		if(m_bRecursive && (m_fileinfo.attrib&_A_SUBDIR))
		{
			if(SetupRecursiveSearch())
			{
				// Get next file.
				GetNextRecursiveFile(sFilename);
				if(sFilename == "")
				{
					KillRecursiveSearch();
					return GetNextFile(sFilename);
				}

				// Return not a directory.
				return false;
			}
			else
				return GetNextFile(sFilename);
		}

		return (m_fileinfo.attrib & _A_SUBDIR) != 0 ? true : false;
	}

	if(_findnext(m_nHandle, &m_fileinfo) == -1)
	{
		sFilename = "";
		return false;
	}

	sFilename = m_fileinfo.name;
	if(sFilename == ".." || sFilename == ".")
		return GetNextFile(sFilename);

	if(m_bRecursive && (m_fileinfo.attrib&_A_SUBDIR))
	{
		if(SetupRecursiveSearch())
		{
			// Get next file.
			GetNextRecursiveFile(sFilename);
			if(sFilename == "")
			{
				KillRecursiveSearch();
				return GetNextFile(sFilename);
			}

			// Return not a directory.
			return false;
		}
		else
			return GetNextFile(sFilename);
	}

	return (m_fileinfo.attrib & _A_SUBDIR) != 0 ? true : false;
}

bool ReadFloat(CFile& hFile, float& fFloat)
{
	float f;

	hFile.Read(&f, 4);
	fFloat = f;
	return true;
}

bool WriteFloat(CFile& hFile, float fFloat)
{
	hFile.Write(&fFloat, 4);
	return true;
}

bool ReadBool(CFile& hFile, bool& bVal)
{
	bool b=false;
	hFile.Read(&b, 1);
	bVal = b;
	return true;
}

bool WriteBool(CFile& hFile, bool bVal)
{
	hFile.Write(&bVal, 1);
	return true;
}


bool ReadNString(CFile& hFile, CString& sString, int nLen)
{
	char* pChar = new char[nLen+1];
	if(pChar == NULL)
		return false;
	hFile.Read(pChar, nLen);
	pChar[nLen] = NULL;
	sString = pChar;
	delete[] pChar;
	return true;
}

bool WriteNString(CFile& hFile, CString sString, int nLen)
{
	hFile.Write((LPCTSTR)sString, nLen);
	return true;
}


bool ReadInt(CFile& hFile, int& nInt)
{
	int nNum;

	hFile.Read(&nNum, 4);
	nInt = nNum;
	return true;
}

bool WriteInt(CFile& hFile, int nInt)
{
	hFile.Write(&nInt, 4);
	return true;
}

bool WriteString(CFile& hFile, CString sString)
{
	int nLen = sString.GetLength();
	hFile.Write(&nLen, 2);
	if(nLen > 0)
		return WriteNString(hFile, sString, sString.GetLength());
	return true;
}

bool ReadLongString(CFile& hFile, CString& sString)
{
	int nLen=0;
	
	hFile.Read(&nLen, 4);
	if(nLen > 0)
		return ReadNString(hFile, sString, nLen);
	sString = "";
	return true;
}

bool ReadString(CFile& hFile, CString& sString)
{
	int nLen=0;
	
	hFile.Read(&nLen, 2);
	if(nLen > 0)
		return ReadNString(hFile, sString, nLen);
	sString = "";
	return true;
}

// Bloads a file into memory.
unsigned char* BloadFile(CString sFilename, int& nNumBytes)
{
	CFile hFile;

	nNumBytes = 0;

	if(!hFile.Open(sFilename, CFile::modeRead | CFile::shareDenyWrite | CFile::typeBinary))
		return NULL;

	nNumBytes = hFile.GetLength();
	if(nNumBytes == 0)
	{
		hFile.Close();
		return NULL;
	}

	// Allocate.
	unsigned char* pData = new unsigned char[nNumBytes];
	if(pData == NULL)
	{
		hFile.Close();
		nNumBytes = 0;
		return NULL;
	}

	// Load the file.
	if(hFile.Read(pData, nNumBytes) != (unsigned int)nNumBytes)
	{
		hFile.Close();
		nNumBytes = 0;
		delete[] pData;
		return NULL;
	}

	hFile.Close();

	return pData;
}

