/*
 Copyright (C) 2010-2017 Kristian Duske

 This file is part of TrenchBroom.

 TrenchBroom is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 TrenchBroom is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with TrenchBroom. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TRENCHBROOM_BITMAPSTATICBUTTON_H
#define TRENCHBROOM_BITMAPSTATICBUTTON_H

#include "View/BitmapButton.h"

#include <wx/bitmap.h>

namespace TrenchBroom {
    namespace View {
        class BitmapStaticButton : public BitmapButton {
        private:
            wxBitmap m_bitmap;
            wxBitmap m_disabledBitmap;
        public:
            BitmapStaticButton(wxWindow* parent, wxWindowID windowId, const wxBitmap& bitmap);
        private:
            wxBitmap currentBitmap() const override;
            void processClick() override;
        };
    }
}

#endif //TRENCHBROOM_BITMAPSTATICBUTTON_H
