	'' String stack

	''
	'' destroy structure
	''
	PRIVATE SUB strstk_t.destroy()
		ptrDestroy(this.List)
		ptrDestroy(this.index)
		this.ListSize = 0
		this.numIndices = 0
	END SUB

	''
	'' clone SOURCE to current structure
	''
	PRIVATE SUB strstk_t.cloneFrom(BYREF source AS strStk_t)
		DIM AS    UBYTE PTR pSrc  = ANY
		DIM AS    UBYTE PTR pDst  = ANY
		DIM AS  INTEGER     i     = ANY

		this.destroy()
		WITH source
			IF ((.ListSize) ANDALSO (.numIndices) ANDALSO (.list) ANDALSO (.index)) THEN
				' copy attributes
				this.ListSize = .ListSize
				ptrCreate(this.list, 0, this.ListSize)
				this.numIndices = .numIndices
				ptrCreate(this.index, 0, this.numIndices)
				' copy string stack
				pDst = CPTR(UBYTE PTR, this.list)
				pSrc = CPTR(UBYTE PTR,     .list)
				FOR i = 0 TO .ListSize - 1
					pDst[i] = pSrc[i]
				NEXT i
				' copy offsets
				FOR i = 0 TO .numIndices - 1
					this.index[i] = .index[i]
				NEXT i
			END IF
		END WITH
	END SUB

	''
	'' return a pointer to the string starting at OFFSET character
	''
	PRIVATE FUNCTION strstk_t.getByOffset(BYREF offset AS INTEGER) AS ZSTRING PTR
		IF ((this.list = 0) OR (this.ListSize = 0) OR (this.index = 0) OR (this.numIndices = 0)) THEN RETURN 0
		IF ((offset < 0) OR (offset >= this.ListSize)) THEN RETURN 0
		RETURN @this.list[offset]
	END FUNCTION

	''
	'' return a pointer to INDEX string (useful when you know the stack is ordered in a specific way)
	''
	PRIVATE FUNCTION strstk_t.getByIndex(BYREF index AS INTEGER) AS ZSTRING PTR
		IF ((this.list = 0) OR (this.ListSize = 0) OR (this.index = 0) OR (this.numIndices = 0)) THEN RETURN 0
		IF ((index < 0) OR (index >= this.numIndices)) THEN RETURN 0
		RETURN @this.list[this.index[index]]
	END FUNCTION

	''
	'' stack MESSAGE inside the string stack, returns its offset or index depending on the mode
	''
	PRIVATE FUNCTION strstk_t.stack(BYREF message AS STRING, BYVAL flags AS INTEGER = 0) AS INTEGER
		DIM AS    UBYTE PTR xPtr        = ANY
		DIM AS    UBYTE PTR strByte     = CPTR(UBYTE   PTR, this.list)
		DIM AS  INTEGER     i           = 0
		DIM AS  INTEGER     msgLen      = LEN(message)
		DIM AS   STRING     tmpName     = message

		' Stack is empty, add first entry
		IF (this.list = 0) THEN
			ptrZString(this.list, message)
			ptrCreate(this.index, 0, 1)
			this.index[this.numIndices] = 0
			this.numIndices = 1
			this.ListSize   = msgLen + 1
			RETURN 0

		' Search in stack
		ELSE
      IF ((flags AND strForceStack) = 0) then
        IF (flags AND strCaseSensitive) THEN
          FOR i = 0 TO this.numIndices - 1
            IF (tmpName <> this.list[this.index[i]]) THEN CONTINUE FOR
            IF (flags AND strReturnIndex) THEN RETURN i ELSE RETURN this.index[i]
          NEXT i
        ELSE
          tmpName = LCASE(tmpName)
          FOR i = 0 TO this.numIndices - 1
            IF (tmpName <> LCASE(this.list[this.index[i]])) THEN CONTINUE FOR
            IF (flags AND strReturnIndex) THEN RETURN i ELSE RETURN this.index[i]
          NEXT i
        END IF
      end if
		END IF

		' String no found, stack it
		ptrCreate(strByte, this.ListSize, this.ListSize + msgLen + 1)
		ptrCreate(this.index, this.numIndices, this.numIndices + 1)
		IF (msgLen) THEN
			xPtr = CPTR(UBYTE PTR, STRPTR(message))
			FOR i = 0 TO msgLen - 1
				strByte[this.ListSize + i] = xPtr[i]
			NEXT i
		END IF
		this.index[this.numIndices] = this.ListSize
		this.ListSize              += msgLen + 1
		this.numIndices            += 1
		this.list                  = strByte
		IF (flags AND strReturnIndex) THEN RETURN this.numIndices ELSE RETURN this.index[this.numIndices - 1]
	END FUNCTION

	''
	'' search MESSAGE inside the string stack
	''
	PRIVATE FUNCTION strstk_t.search(BYREF message AS STRING, BYVAL flags AS INTEGER = 0) AS INTEGER
		DIM AS  INTEGER i       = 0
		DIM AS   STRING tmpName = message
		
		IF (flags AND strCaseSensitive) THEN
			FOR i = 0 TO this.numIndices - 1
				IF (tmpName <> this.list[this.index[i]]) THEN CONTINUE FOR
				IF (flags AND strReturnIndex) THEN RETURN i ELSE RETURN this.index[i]
			NEXT i
		ELSE
			tmpName = LCASE(tmpName)
			FOR i = 0 TO this.numIndices - 1
				IF (tmpName <> LCASE(this.list[this.index[i]])) THEN CONTINUE FOR
				IF (flags AND strReturnIndex) THEN RETURN i ELSE RETURN this.index[i]
			NEXT i
		END IF
		RETURN -1
	END FUNCTION
  
  ''
  '' split string into a string stack
  ''
  PRIVATE SUB strstk_t.stackStr(BYREF msg AS STRING, byval separator as ubyte = &h2C)
    DIM AS  INTEGER     i     = ANY
    DIM AS   STRING     tmp   = ""
    DIM AS   STRING     lst   = TRIM(msg)
    DIM AS    UBYTE PTR xPtr  = ANY
    
    this.destroy()
    IF (LEN(lst) = 0) THEN EXIT SUB
    xPtr = CPTR(UBYTE PTR, STRPTR(lst))

    FOR i = 0 TO LEN(lst) - 1
      IF (xPtr[i] = separator) THEN
        tmp = TRIM(tmp)
        this.stack(tmp, strForceStack)
        tmp = ""
      ELSE
        tmp += CHR(xPtr[i])
      END IF
    NEXT i
    tmp = TRIM(tmp)
    IF LEN(tmp) THEN this.stack(tmp, strForceStack)
  END SUB
