	'' String stack, header

	'' NOTE: the string stack structure relies on offsets instead of direct
	'' pointers because pointers WILL become unusable after each modification
	'' of the stack.

	#DEFINE strCaseSensitive    &h01
	#DEFINE strReturnIndex      &h02
  #DEFINE strForceStack       &h04

	TYPE strStk_t
		AS  ZSTRING PTR List          ' String stack
		AS UINTEGER PTR index         ' Starting offset of each string
		AS UINTEGER     listSize      ' Size of the stack, in bytes
		AS UINTEGER     numIndices    ' Number of strings
		DECLARE FUNCTION getByOffset(BYREF offset AS INTEGER) AS ZSTRING PTR
		DECLARE FUNCTION getByIndex(BYREF index AS INTEGER) AS ZSTRING PTR
		DECLARE FUNCTION stack(BYREF message AS STRING, BYVAL flags AS INTEGER = 0) AS INTEGER
    DECLARE FUNCTION search(BYREF message AS STRING, BYVAL flags AS INTEGER = 0) AS INTEGER
		DECLARE SUB      cloneFrom(BYREF source AS strStk_t)
    DECLARE SUB      stackStr(BYREF msg AS STRING, byval separator as ubyte = &h2C)
		DECLARE SUB      destroy()
	END TYPE
